/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.struct;

public class Vec3f {
    public float x;
    public float y;
    public float z;

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float distSq(Vec3f other) {
        return (other.x - this.x) * (other.x - this.x) + (other.y - this.y) * (other.y - this.y) + (other.z - this.z) * (other.z - this.z);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec3f subtract(Vec3f v) {
        return new Vec3f(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vec3f add(Vec3f v) {
        return new Vec3f(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vec3f normalize() {
        float length = this.length();
        return new Vec3f(this.x / length, this.y / length, this.z / length);
    }

    public Vec3f scale(float scale) {
        return new Vec3f(this.x * scale, this.y * scale, this.z * scale);
    }

    public boolean equals(Object v) {
        if (v instanceof Vec3f) {
            Vec3f v3 = (Vec3f)v;
            return v3.x == this.x && v3.y == this.y && v3.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return ("" + this.x + "_" + this.y + "_" + this.z).hashCode();
    }

    public Vec3f cross(Vec3f v) {
        return new Vec3f(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }
}

