/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.model.item;

import com.google.common.collect.ImmutableList;
import elucent.elulib.model.CustomModelItem;
import elucent.elulib.model.DefaultTransformations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelItem
implements IBakedModel {
    Function<ResourceLocation, TextureAtlasSprite> getter;
    VertexFormat format;
    ImmutableList.Builder<BakedQuad> quads = ImmutableList.builder();
    List<TextureAtlasSprite> layers = new ArrayList<TextureAtlasSprite>();
    CustomModelItem model = null;
    List<BakedQuad> layerQuads = new ArrayList<BakedQuad>();

    public BakedModelItem(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, CustomModelItem model) {
        this.getter = bakedTextureGetter;
        this.format = format;
        int i = 0;
        this.model = model;
        while (model.textures.containsKey("layer" + i)) {
            this.layers.add(this.getter.apply((ResourceLocation)model.textures.get("layer" + i)));
            this.layerQuads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)this.layers.get(i), (VertexFormat)format, Optional.empty()));
            ++i;
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.layerQuads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Arrays.asList(new ItemOverride[0]));
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        Matrix4f matrix = null;
        if (this.model.handheld) {
            if (DefaultTransformations.handheldTransforms.containsKey(type)) {
                matrix = DefaultTransformations.handheldTransforms.get(type).getMatrix();
                return Pair.of((Object)this, (Object)matrix);
            }
        } else if (DefaultTransformations.itemTransforms.containsKey(type)) {
            matrix = DefaultTransformations.itemTransforms.get(type).getMatrix();
            return Pair.of((Object)this, (Object)matrix);
        }
        return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
    }
}

