/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.model.block;

import elucent.elulib.model.CustomModelBase;
import elucent.elulib.model.DefaultTransformations;
import elucent.elulib.model.ModelUtil;
import elucent.elulib.model.block.BakedModelBlock;
import elucent.elulib.model.parts.Cube;
import elucent.elulib.struct.Vec4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelSlab
extends BakedModelBlock {
    Cube cube_down;
    Cube cube_up;
    public static Vec4f FULL_FACE_UV = new Vec4f(0.0f, 0.0f, 16.0f, 16.0f);
    public static Vec4f BOTTOM_SIDE_UV = new Vec4f(0.0f, 8.0f, 16.0f, 8.0f);
    public static Vec4f TOP_SIDE_UV = new Vec4f(0.0f, 0.0f, 16.0f, 8.0f);
    public static Vec4f[] bottomUV = new Vec4f[]{BOTTOM_SIDE_UV, BOTTOM_SIDE_UV, FULL_FACE_UV, FULL_FACE_UV, BOTTOM_SIDE_UV, BOTTOM_SIDE_UV};
    public static Vec4f[] topUV = new Vec4f[]{TOP_SIDE_UV, TOP_SIDE_UV, FULL_FACE_UV, FULL_FACE_UV, TOP_SIDE_UV, TOP_SIDE_UV};

    public BakedModelSlab(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, CustomModelBase model) {
        super(state, format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.cube_down = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 1.0, 0.5, 1.0, null, texes, 0).setNoCull(EnumFacing.UP);
        this.cube_up = ModelUtil.makeCube(format, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0, null, texes, 0).setNoCull(EnumFacing.DOWN);
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    public void getFaceQuads(List<BakedQuad> quads, EnumFacing side, IBlockState state) {
        if (state == null) {
            this.cube_down.addToList(quads, side);
        } else {
            BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a);
            if (half == BlockSlab.EnumBlockHalf.BOTTOM) {
                this.cube_down.addToList(quads, side);
            } else if (half == BlockSlab.EnumBlockHalf.TOP) {
                this.cube_up.addToList(quads, side);
            }
        }
    }

    @Override
    public boolean func_177555_b() {
        return true;
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Arrays.asList(new ItemOverride[0]));
    }

    @Override
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        Matrix4f matrix = null;
        if (DefaultTransformations.blockTransforms.containsKey(type)) {
            matrix = DefaultTransformations.blockTransforms.get(type).getMatrix();
            return Pair.of((Object)this, (Object)matrix);
        }
        return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
    }
}

