/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.gui;

import elucent.elulib.gui.GuiModular;
import elucent.elulib.gui.IGuiElement;
import elucent.elulib.util.FluidTextureUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ElementFluidTank
implements IGuiElement {
    public int x = 0;
    public int y = 0;
    public IFluidTankProperties tank = null;
    public ResourceLocation texture = GuiModular.baseTexture;

    public ElementFluidTank(int x, int y, IFluidTankProperties tank) {
        this.x = x;
        this.y = y;
        this.tank = tank;
    }

    public ElementFluidTank(int x, int y, IFluidTankProperties tank, ResourceLocation texture) {
        this.x = x;
        this.y = y;
        this.tank = tank;
        this.texture = texture;
    }

    @Override
    public void draw(GuiContainer g, float partialTicks, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        if (this.tank != null && this.tank.getContents() != null && this.tank.getContents().getFluid() != null) {
            float coeff = (float)this.tank.getContents().amount / (float)this.tank.getCapacity();
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            Minecraft.func_71410_x().func_147117_R();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = FluidTextureUtil.stillTextures.get(this.tank.getContents().getFluid());
            GlStateManager.func_179147_l();
            int height = Math.round(64.0f * coeff);
            if (sprite != null) {
                int i = 0;
                for (i = 0; i <= height - 16; i += 16) {
                    g.func_175175_a(g.getGuiLeft() + this.x, g.getGuiTop() + this.y + 1 + (64 - (i + 16)) - height % 16, sprite, 16, 16);
                }
                int remainder = height - i;
                double swidth = sprite.func_94212_f() - sprite.func_94209_e();
                double sheight = sprite.func_94210_h() - sprite.func_94206_g();
                GuiModular.drawTexturedModalRectWithCustomUV(g.getGuiLeft() + this.x, g.getGuiTop() + this.y + 1 + 64 - height % 16, sprite.func_94209_e(), sprite.func_94206_g(), (double)sprite.func_94209_e() + swidth, (double)sprite.func_94206_g() + (sheight *= (double)((float)(height - i) / 16.0f)), 16, height - i);
            }
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        }
        g.func_73729_b(g.getGuiLeft() + this.x, g.getGuiTop() + this.y, 224, 64, 16, 66);
        g.func_73729_b(g.getGuiLeft() + this.x, g.getGuiTop() + this.y, 208, 64, 16, 66);
        if (mouseX >= g.getGuiLeft() + this.x && mouseY >= g.getGuiTop() + this.y && mouseX < g.getGuiLeft() + this.x + 16 && mouseY < g.getGuiTop() + this.y + 66) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            g.func_73729_b(g.getGuiLeft() + this.x, g.getGuiTop() + this.y, 240, 64, 16, 66);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }
    }

    @Override
    public void drawTooltip(GuiContainer g, float partialTicks, int mouseX, int mouseY) {
        if (mouseX >= g.getGuiLeft() + this.x && mouseY >= g.getGuiTop() + this.y && mouseX < g.getGuiLeft() + this.x + 16 && mouseY < g.getGuiTop() + this.y + 66 && this.tank.getContents() != null) {
            g.func_146279_a("" + this.tank.getContents().amount + " / " + this.tank.getCapacity(), mouseX, mouseY);
        }
    }

    @Override
    public void onClick(GuiContainer g, int mouseX, int mouseY) {
    }
}

