/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.block;

import elucent.elulib.ELRegistry;
import elucent.elulib.block.CustomStateMapper;
import elucent.elulib.block.IBlock;
import elucent.elulib.model.CustomModelBlock;
import elucent.elulib.model.CustomModelLoader;
import elucent.elulib.model.ICustomModeledObject;
import elucent.elulib.model.IModeledObject;
import elucent.elulib.model.block.BakedModelWall;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWallBase
extends BlockWall
implements IBlock,
IModeledObject,
ICustomModeledObject {
    Item itemBlock = null;
    public List<ItemStack> drops = null;
    boolean isOpaque = false;
    protected boolean hasCustomModel = false;
    BlockRenderLayer layer = BlockRenderLayer.SOLID;
    protected Block parent;
    public String name = "";

    public BlockWallBase(Block base, SoundType type, float hardness, String name) {
        super(base);
        this.func_149647_a(null);
        this.parent = base;
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(type);
        this.func_149713_g(0);
        this.func_149711_c(hardness);
        this.setOpacity(false);
        this.field_149787_q = false;
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(ELRegistry.getActiveModid(), name);
    }

    public BlockWallBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    public BlockWallBase setHarvestReqs(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    public BlockWallBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    public BlockWallBase setLayer(BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_149708_J()) {
            list.add((Object)new ItemStack((Block)this, 1));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.parent.getRegistryName().func_110624_b() + ":blocks/" + this.parent.getRegistryName().func_110623_a());
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(BakedModelWall.class, defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#inventory"), new CustomModelBlock(BakedModelWall.class, defaultTex, defaultTex));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }
}

