/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverstuffs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.PacketHandler;
import net.creeperhost.minetogether.Util;
import net.creeperhost.minetogether.common.Config;
import net.creeperhost.minetogether.common.Pair;
import net.creeperhost.minetogether.serverstuffs.IServerProxy;
import net.creeperhost.minetogether.serverstuffs.MineTogetherPropertyManager;
import net.creeperhost.minetogether.serverstuffs.command.CommandInvite;
import net.creeperhost.minetogether.serverstuffs.command.CommandPregen;
import net.creeperhost.minetogether.serverstuffs.hacky.IPlayerKicker;
import net.creeperhost.minetogether.serverstuffs.pregen.PregenTask;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="minetogetherserver", name="MineTogetherServer", version="unspecified", acceptableRemoteVersions="*", acceptedMinecraftVersions="1.9.4,1.10.2,1.11.2")
public class CreeperHostServer {
    public static final String MOD_ID = "minetogetherserver";
    public static final String NAME = "MineTogetherServer";
    public static Logger logger;
    @SidedProxy(clientSide="net.creeperhost.minetogether.serverstuffs.ClientProxy", serverSide="net.creeperhost.minetogether.serverstuffs.ServerProxy")
    public static IServerProxy proxy;
    @Mod.Instance(value="minetogetherserver")
    public static CreeperHostServer INSTANCE;
    private static String secret;
    public HashMap<Integer, PregenTask> pregenTasks = new HashMap();
    private boolean needsToBeKilled = true;
    private boolean watchdogKilled = false;
    private boolean watchdogChecked = false;
    public boolean serverOn;
    public static int updateID;
    Discoverability discoverMode = Discoverability.UNLISTED;
    int tries = 0;
    WeakHashMap<EntityPlayerMP, Boolean> playersJoined = new WeakHashMap();
    private static ArrayList<String> oldVersions;
    public IPlayerKicker kicker;

    public static Thread getThreadByName(String threadName) {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getName().equals(threadName)) continue;
            return t;
        }
        return null;
    }

    private void killWatchdog() {
        if (!this.watchdogChecked) {
            this.needsToBeKilled = proxy.needsToBeKilled();
            this.watchdogChecked = true;
        }
        if (!this.watchdogKilled && this.needsToBeKilled) {
            this.watchdogKilled = proxy.killWatchdog();
        }
    }

    private void resuscitateWatchdog() {
        if (this.watchdogKilled && this.needsToBeKilled) {
            proxy.resuscitateWatchdog();
            this.watchdogKilled = false;
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (!CreeperHost.instance.active) {
            return;
        }
        event.registerServerCommand((ICommand)new CommandInvite());
        event.registerServerCommand((ICommand)new CommandPregen());
        this.deserializePreload(new File(this.getSaveFolder(), "pregenData.json"));
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (!CreeperHost.instance.active) {
            return;
        }
        final MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && !server.func_71264_H()) {
            DedicatedServer dediServer = (DedicatedServer)server;
            String discoverModeString = dediServer.func_71330_a("discoverability", "unlisted");
            String displayNameTemp = dediServer.func_71330_a("displayname", "Fill this in if you have set the server to public!");
            final String serverIP = dediServer.func_71330_a("server-ip", "");
            final String projectid = Config.getInstance().curseProjectID;
            if (displayNameTemp.equals("Fill this in if you have set the server to public!") && discoverModeString.equals("unlisted")) {
                File outProperties = new File("minetogether.properties");
                if (outProperties.exists()) {
                    MineTogetherPropertyManager manager = new MineTogetherPropertyManager(outProperties);
                    displayNameTemp = manager.getStringProperty("displayname", "Fill this in if you have set the server to public!");
                    discoverModeString = manager.getStringProperty("discoverability", "unlisted");
                } else {
                    displayNameTemp = "Unknown";
                    discoverModeString = "unlisted";
                }
            }
            final String displayName = displayNameTemp;
            this.serverOn = true;
            try {
                this.discoverMode = Discoverability.valueOf(discoverModeString.toUpperCase());
            }
            catch (IllegalArgumentException manager) {
                // empty catch block
            }
            if (this.discoverMode != Discoverability.UNLISTED) {
                Config defConfig = new Config();
                if (projectid.isEmpty() || projectid.equals(defConfig.curseProjectID)) {
                    logger.warn("Curse project ID in creeperhost.cfg not set correctly - please set this to utilize the server list feature.");
                    return;
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Enabling server list. Servers found to be breaking Mojang's EULA may be removed if complaints are received.");
                        boolean first = true;
                        while (CreeperHostServer.this.serverOn) {
                            HashMap<String, Object> send = new HashMap<String, Object>();
                            if (!serverIP.isEmpty()) {
                                send.put("ip", serverIP);
                            }
                            if (secret != null) {
                                send.put("secret", secret);
                            }
                            send.put("name", displayName);
                            send.put("projectid", projectid);
                            send.put("port", String.valueOf(server.func_71215_F()));
                            send.put("invite-only", CreeperHostServer.this.discoverMode == Discoverability.INVITE ? "1" : "0");
                            send.put("version", 2);
                            Gson gson = new Gson();
                            String sendStr = gson.toJson(send);
                            String resp = Util.putWebResponse("https://api.creeper.host/serverlist/update", sendStr, true, true);
                            int sleepTime = 90000;
                            try {
                                JsonElement jElement = new JsonParser().parse(resp);
                                if (jElement.isJsonObject()) {
                                    JsonObject jObject = jElement.getAsJsonObject();
                                    if (jObject.get("status").getAsString().equals("success")) {
                                        CreeperHostServer.this.tries = 0;
                                        updateID = jObject.get("id").getAsNumber().intValue();
                                        if (jObject.has("secret")) {
                                            secret = jObject.get("secret").getAsString();
                                        }
                                    } else if (CreeperHostServer.this.tries >= 4) {
                                        logger.error("Unable to do call to server list - disabling for 45 minutes. Reason: " + jObject.get("message").getAsString());
                                        CreeperHostServer.this.tries = 0;
                                        sleepTime = 2700000;
                                    } else {
                                        logger.error("Unable to do call to server list - will try again in 90 seconds. Reason: " + jObject.get("message").getAsString());
                                        ++CreeperHostServer.this.tries;
                                    }
                                    if (first) {
                                        CommandInvite.reloadInvites(new String[0]);
                                        first = false;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                });
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        if (!CreeperHost.instance.active) {
            return;
        }
        this.serverOn = false;
        this.serializePreload();
        this.pregenTasks.clear();
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (!CreeperHost.instance.active) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null || server.func_71264_H()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            if (!this.playersJoined.containsKey(entity)) {
                this.playersJoined.put((EntityPlayerMP)entity, null);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketHandler.ServerIDMessage(updateID), (EntityPlayerMP)entity);
            }
            for (PregenTask task : this.pregenTasks.values()) {
                if (!task.preventJoin) continue;
                this.kicker.kickPlayer((EntityPlayerMP)entity, "Server is still pre-generating!\n" + task.lastPregenString);
                logger.error("Kicked player " + entity.func_70005_c_() + " as still pre-generating");
                break;
            }
            event.setCanceled(true);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        if (!CreeperHost.instance.active) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        logger = e.getModLog();
        this.setupPlayerKicker();
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent e) {
        if (!CreeperHost.instance.active) {
            return;
        }
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71278_l()) {
            return;
        }
        WorldServer world = (WorldServer)e.world;
        int dimension = world.field_73011_w.getDimension();
        PregenTask task = this.pregenTasks.get(dimension);
        if (task == null) {
            return;
        }
        if (task.chunksToGen.isEmpty()) {
            logger.info("No more chunks to generate for dimension " + dimension + " - removing task!");
            this.pregenTasks.remove(dimension);
            if (this.pregenTasks.isEmpty()) {
                this.resuscitateWatchdog();
            }
            this.serializePreload();
            return;
        }
        int max = task.chunksPerTick;
        ArrayList<Pair<Integer, Integer>> chunkToGen = new ArrayList<Pair<Integer, Integer>>();
        int i = 0;
        for (Pair<Integer, Integer> pair : task.chunksToGen) {
            if (i >= max) break;
            chunkToGen.add(pair);
            ++i;
        }
        long curTime = System.currentTimeMillis();
        if (task.startTime == 0L) {
            task.lastCheckedTime = curTime;
            task.startTime = curTime;
        }
        if (curTime - task.lastCheckedTime >= 10000L) {
            task.lastCheckedTime = curTime;
            int lastChunks = task.lastChunksDone;
            task.lastChunksDone = task.chunksDone;
            int n = task.chunksDone - lastChunks;
            long deltaTime = curTime - task.startTime;
            double timePerChunk = (double)deltaTime / (double)task.chunksDone;
            long chunksRemaining = task.totalChunks - task.chunksDone;
            long estimatedTime = (long)((double)chunksRemaining * timePerChunk);
            long days = TimeUnit.MILLISECONDS.toDays(estimatedTime);
            long hours = TimeUnit.MILLISECONDS.toHours(estimatedTime -= TimeUnit.DAYS.toMillis(days));
            long minutes = TimeUnit.MILLISECONDS.toMinutes(estimatedTime -= TimeUnit.HOURS.toMillis(hours));
            long seconds = TimeUnit.MILLISECONDS.toSeconds(estimatedTime -= TimeUnit.MINUTES.toMillis(minutes));
            String time = days + " day(s) " + hours + " hour(s) " + minutes + " minute(s) " + seconds + " second(s)";
            task.lastPregenString = "Pre-generating chunks for dimension " + dimension + ", current speed " + n + " every 10 seconds.\n" + task.chunksDone + "/" + task.totalChunks + " " + time + " remaining";
            logger.info(task.lastPregenString);
            if (task.curChunksPerTick == 0 && world.func_72863_F().func_73152_e() < task.chunkLoadCount) {
                logger.info("Chunks appear to be unloading now - going to tentatively restart the pregen.");
                task.curChunksPerTick = 1;
            }
            if (world.func_72863_F().func_73152_e() >= task.chunkLoadCount + n * 2) {
                task.chunkLoadCount = world.func_72863_F().func_73152_e();
                --task.curChunksPerTick;
                if (task.curChunksPerTick == 0) {
                    logger.info("Frozen chunk generating as it appears that chunks aren't being unloaded fast enough. Will check the status in another 10 seconds.");
                }
            } else if (task.curChunksPerTick < task.chunksPerTick) {
                ++task.curChunksPerTick;
            }
            this.serializePreload();
        }
        this.killWatchdog();
        for (Pair pair : chunkToGen) {
            world.func_72863_F().func_186025_d(((Integer)pair.getLeft()).intValue(), ((Integer)pair.getRight()).intValue());
            task.storedCurX = (Integer)pair.getLeft();
            task.storedCurZ = (Integer)pair.getRight();
            ++task.chunksDone;
        }
        if (task.chunksDone != 0 && task.chunksDone % 1000 == 0) {
            world.func_72860_G().func_75759_a();
        }
        task.chunksToGen.removeAll(chunkToGen);
    }

    public File getSaveFolder() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && !server.func_71264_H()) {
            return server.func_71209_f("");
        }
        return DimensionManager.getCurrentSaveRootDirectory();
    }

    public void serializePreload() {
        this.serializePreload(new File(this.getSaveFolder(), "pregenData.json"));
    }

    private void serializePreload(File file) {
        FileOutputStream pregenOut = null;
        Type listOfPregenTask = new TypeToken<HashMap<Integer, PregenTask>>(){}.getType();
        try {
            pregenOut = new FileOutputStream(file);
            Gson gson = new GsonBuilder().create();
            String output = gson.toJson(this.pregenTasks, listOfPregenTask);
            IOUtils.write((String)output, (OutputStream)pregenOut);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deserializePreload(File file) {
        Gson gson = new GsonBuilder().create();
        HashMap output = null;
        Type listOfPregenTask = new TypeToken<HashMap<Integer, PregenTask>>(){}.getType();
        try {
            output = (HashMap)gson.fromJson(IOUtils.toString((URI)file.toURI()), listOfPregenTask);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pregenTasks = output == null ? new HashMap() : output;
        Collection<PregenTask> tasks = this.pregenTasks.values();
        for (PregenTask task : tasks) {
            task.init();
        }
    }

    public boolean createTask(int dimension, int xMin, int xMax, int zMin, int zMax, int chunksPerTick, boolean preventJoin) {
        if (this.pregenTasks.get(dimension) != null) {
            return false;
        }
        this.pregenTasks.put(dimension, new PregenTask(dimension, xMin, xMax, zMin, zMax, chunksPerTick, preventJoin));
        return true;
    }

    public void setupPlayerKicker() {
        if (this.kicker == null) {
            String mcVersion;
            String className = "net.creeperhost.minetogether.serverstuffs.hacky.NewPlayerKicker";
            try {
                mcVersion = (String)ForgeVersion.class.getField("mcVersion").get(null);
            }
            catch (Throwable e) {
                mcVersion = "unknown";
            }
            if (oldVersions.contains(mcVersion)) {
                className = "net.creeperhost.minetogether.serverstuffs.hacky.OldPlayerKicker";
            }
            try {
                Class<?> clazz = Class.forName(className);
                this.kicker = (IPlayerKicker)clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        oldVersions = new ArrayList<String>(){
            {
                this.add("1.9");
                this.add("1.9.4");
                this.add("1.10");
                this.add("1.10.2");
                this.add("1.11");
                this.add("1.11.2");
            }
        };
    }

    public static class InviteClass {
        public int id = updateID;
        public ArrayList<String> hash;
    }

    private static enum Discoverability {
        UNLISTED,
        PUBLIC,
        INVITE;

    }
}

