/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import shetiphian.core.common.Function;
import shetiphian.core.common.tileentity.TileEntityBase;

public class TileEntityExtendedRedstone
extends TileEntityBase {
    private static final int MULTIPLIER = 5;
    private static final int MAXIMUM = 75;
    private int redstone = 0;
    private boolean enabled = true;

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74768_a("redstone", this.redstone);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        this.redstone = nbtTag.func_74762_e("redstone");
    }

    public int getExPower() {
        return MathHelper.func_76125_a((int)this.redstone, (int)0, (int)75);
    }

    public int getRSPower() {
        return MathHelper.func_76125_a((int)(this.redstone / 5), (int)0, (int)15);
    }

    public void setExPower(int redstone) {
        this.redstone = MathHelper.func_76125_a((int)redstone, (int)0, (int)75);
    }

    public void setRSPower(int redstone) {
        this.redstone = MathHelper.func_76125_a((int)redstone, (int)0, (int)15) * 5;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean updatePower() {
        int powerIn;
        int newPower;
        int currentPower;
        if (!this.func_145831_w().field_72995_K && (currentPower = this.getExPower()) != (newPower = MathHelper.func_76125_a((int)((powerIn = this.isEnabled() ? this.doPowerCalculation() : 0) - 1), (int)0, (int)75))) {
            this.setExPower(newPower);
            Function.syncTile(this);
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.func_145831_w().func_175685_c(this.func_174877_v().func_177972_a(enumfacing), this.func_145838_q(), true);
            }
            return true;
        }
        return false;
    }

    private int doPowerCalculation() {
        int power = this.getPowerAt(this.func_174877_v().func_177977_b(), EnumFacing.DOWN);
        if (power >= 75) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.func_174877_v().func_177984_a(), EnumFacing.UP))) >= 75) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.func_174877_v().func_177978_c(), EnumFacing.NORTH))) >= 75) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.func_174877_v().func_177968_d(), EnumFacing.SOUTH))) >= 75) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.func_174877_v().func_177976_e(), EnumFacing.WEST))) >= 75) {
            return power;
        }
        return (power = Math.max(power, this.getPowerAt(this.func_174877_v().func_177974_f(), EnumFacing.EAST))) >= 75 ? power : power;
    }

    private int getPowerAt(BlockPos pos, EnumFacing direction) {
        TileEntity tile = this.func_145831_w().func_175625_s(pos);
        if (tile instanceof TileEntityExtendedRedstone) {
            return ((TileEntityExtendedRedstone)tile).getExPower();
        }
        return this.func_145831_w().func_180495_p(pos).func_185893_b((IBlockAccess)this.func_145831_w(), pos, direction) * 5;
    }
}

