/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util.misc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public final class Node
implements Comparable<Node> {
    public static final Node ALL = new Node(new String[]{"*"});
    public static final Node COMMAND = new Node(new String[]{"command"});
    private static final LoadingCache<String, Node> CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Node>(){

        public Node load(String string) {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : string.split("\\.")) {
                if ((s = s.trim()).isEmpty()) continue;
                list.add(s.toLowerCase());
            }
            int size = list.size();
            if (size == 0 || ((String)list.get(0)).charAt(0) == '*') {
                return ALL;
            }
            while (size > 0 && ((String)list.get(size - 1)).charAt(0) == '*') {
                list.remove(size - 1);
                --size;
            }
            return list.isEmpty() ? ALL : new Node(list.toArray(new String[size]));
        }
    });
    private final String[] parts;
    private final String string;

    public static Node get(String string) {
        if (string.isEmpty() || string.charAt(0) == '*') {
            return ALL;
        }
        try {
            return (Node)CACHE.get((Object)string);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to create node from '" + string + "'!");
        }
    }

    private Node(String[] p) {
        this.parts = p;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.parts.length; ++i) {
            if (i > 0) {
                builder.append('.');
            }
            builder.append(this.parts[i]);
        }
        this.string = builder.toString();
    }

    public String toString() {
        return this.string;
    }

    public Node append(String name) {
        return Node.get(this.string + '.' + name);
    }

    public Node append(Node node) {
        if (node == ALL) {
            return this;
        }
        String[] nparts = new String[this.parts.length + node.parts.length];
        System.arraycopy(this.parts, 0, nparts, 0, this.parts.length);
        System.arraycopy(node.parts, 0, nparts, this.parts.length, node.parts.length);
        return new Node(nparts);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Node) {
            Node n = (Node)o;
            if (this.parts.length != n.parts.length) {
                return false;
            }
            for (int i = 0; i < this.parts.length; ++i) {
                if (this.parts[i].equals(n.parts[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public int compareTo(Node o) {
        return this.string.compareTo(o.string);
    }

    public int getPartCount() {
        return this.parts.length;
    }

    public String getPart(int index) {
        return this.parts[index];
    }

    public String[] createPartArray() {
        String[] array = new String[this.parts.length];
        System.arraycopy(this.parts, 0, array, 0, array.length);
        return array;
    }

    public boolean matches(Node node) {
        if (this == ALL) {
            return true;
        }
        if (node.parts.length < this.parts.length) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].equals(node.parts[i])) continue;
            return false;
        }
        return true;
    }
}

