/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class ServerUtils {
    public static double getMovementFactor(int dim) {
        switch (dim) {
            case 0: 
            case 1: {
                return 1.0;
            }
            case -1: {
                return 8.0;
            }
        }
        WorldServer w = DimensionManager.getWorld((int)dim);
        return w == null ? 1.0 : w.field_73011_w.getMovementFactor();
    }

    public static ITextComponent getDimensionName(int dim) {
        switch (dim) {
            case 0: {
                return new TextComponentTranslation("createWorld.customize.preset.overworld", new Object[0]);
            }
            case -1: {
                return new TextComponentTranslation("advancements.nether.root.title", new Object[0]);
            }
            case 1: {
                return new TextComponentTranslation("advancements.end.root.title", new Object[0]);
            }
        }
        return new TextComponentString("DIM_" + dim);
    }

    public static boolean isVanillaClient(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            NetHandlerPlayServer connection = ((EntityPlayerMP)sender).field_71135_a;
            return connection != null && (Boolean)connection.field_147371_a.channel().attr(NetworkRegistry.FML_MARKER).get() == false;
        }
        return false;
    }

    public static boolean isFake(EntityPlayerMP player) {
        return player.field_71135_a == null || player instanceof FakePlayer;
    }

    public static boolean isOP(@Nullable MinecraftServer server, @Nullable GameProfile profile) {
        if (profile == null || profile.getId() == null || profile.getName() == null) {
            return false;
        }
        if (server == null && (server = FMLCommonHandler.instance().getMinecraftServerInstance()) == null) {
            return false;
        }
        return server.func_184103_al().func_152596_g(profile);
    }

    public static boolean isOP(EntityPlayerMP player) {
        return ServerUtils.isOP(player.field_71133_b, player.func_146103_bH());
    }

    public static Collection<ICommand> getAllCommands(MinecraftServer server, ICommandSender sender) {
        HashSet<ICommand> commands = new HashSet<ICommand>();
        for (ICommand c : server.func_71187_D().func_71555_a().values()) {
            if (!c.func_184882_a(server, sender)) continue;
            commands.add(c);
        }
        return commands;
    }

    public static SpawnType canMobSpawn(World world, BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return SpawnType.CANT_SPAWN;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)pos) || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) >= 8) {
            return SpawnType.CANT_SPAWN;
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o() + 0.01, (double)pos.func_177952_p() + 0.2, (double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + 1.8, (double)pos.func_177952_p() + 0.8);
        if (!world.func_72855_b(aabb) || world.func_72953_d(aabb)) {
            return SpawnType.CANT_SPAWN;
        }
        return chunk.func_177413_a(EnumSkyBlock.SKY, pos) >= 8 ? SpawnType.ONLY_AT_NIGHT : SpawnType.ALWAYS_SPAWNS;
    }

    @Nullable
    public static Entity getEntityByUUID(World world, UUID uuid) {
        for (Entity e : world.field_72996_f) {
            if (!e.func_110124_au().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    public static void notify(MinecraftServer server, @Nullable EntityPlayer player, ITextComponent component) {
        if (player == null) {
            for (EntityPlayer player1 : server.func_184103_al().func_181057_v()) {
                player1.func_146105_b(component, true);
            }
        } else {
            player.func_146105_b(component, true);
        }
    }

    public static enum SpawnType {
        CANT_SPAWN,
        ALWAYS_SPAWNS,
        ONLY_AT_NIGHT;

    }
}

