/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui.misc;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.TextBox;
import com.feed_the_beast.ftblib.lib.gui.misc.IGuiFieldCallback;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiConfigValueField
extends GuiBase {
    private final ConfigValue defValue;
    private final ConfigValue value;
    private final IGuiFieldCallback callback;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final TextBox textBox;

    GuiConfigValueField(ConfigValue val, IGuiFieldCallback c) {
        this.setSize(200, 54);
        this.defValue = val.copy();
        this.value = val.copy();
        this.callback = c;
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.defValue, false);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                if (GuiConfigValueField.this.value.setValueFromString(GuiConfigValueField.this.textBox.getText(), false)) {
                    GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.value, true);
                }
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.textBox = new TextBox(this){

            @Override
            public boolean isValid(String txt) {
                return GuiConfigValueField.this.value.setValueFromString(txt, true);
            }

            @Override
            public void onTextChanged() {
                ((GuiConfigValueField)GuiConfigValueField.this).textBox.textColor = GuiConfigValueField.this.value.getColor();
            }

            @Override
            public void onEnterPressed() {
                GuiConfigValueField.this.buttonAccept.onClicked(MouseButton.LEFT);
            }
        };
        this.textBox.setPosAndSize(8, 8, this.width - 16, 16);
        this.textBox.writeText(val.getGuiText());
        this.textBox.setFocused(true);
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }

    @Override
    public boolean doesGuiPauseGame() {
        GuiScreen screen = this.getPrevScreen();
        return screen != null && screen.func_73868_f();
    }
}

