/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Widget;

public interface WidgetLayout {
    public static final WidgetLayout NONE = panel -> 0;
    public static final WidgetLayout VERTICAL = new Vertical(0, 0, 0);
    public static final WidgetLayout HORIZONTAL = new Horizontal(0, 0, 0);

    public int align(Panel var1);

    public static class Horizontal
    implements WidgetLayout {
        private final int pre;
        private final int spacing;
        private final int post;

        public Horizontal(int _pre, int _spacing, int _post) {
            this.pre = _pre;
            this.spacing = _spacing;
            this.post = _post;
        }

        @Override
        public int align(Panel panel) {
            int i = this.pre;
            if (!panel.widgets.isEmpty()) {
                for (Widget widget : panel.widgets) {
                    widget.setX(i);
                    i += widget.width + this.spacing;
                }
                i -= this.spacing;
            }
            return i + this.post;
        }
    }

    public static class Vertical
    implements WidgetLayout {
        private final int pre;
        private final int spacing;
        private final int post;

        public Vertical(int _pre, int _spacing, int _post) {
            this.pre = _pre;
            this.spacing = _spacing;
            this.post = _post;
        }

        @Override
        public int align(Panel panel) {
            int i = this.pre;
            if (!panel.widgets.isEmpty()) {
                for (Widget widget : panel.widgets) {
                    widget.setY(i);
                    i += widget.height + this.spacing;
                }
                i -= this.spacing;
            }
            return i + this.post;
        }
    }
}

