/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.MismatchingParentPanelException;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public abstract class Panel
extends Widget {
    public final List<Widget> widgets = new ArrayList<Widget>();
    private int scrollX = 0;
    private int scrollY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean unicode = false;
    private boolean onlyRenderWidgetsInside = true;
    private boolean onlyInteractWithWidgetsInside = true;

    public Panel(Panel panel) {
        super(panel);
    }

    public boolean getUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean value) {
        this.unicode = value;
    }

    public boolean getOnlyRenderWidgetsInside() {
        return this.onlyRenderWidgetsInside;
    }

    public void setOnlyRenderWidgetsInside(boolean value) {
        this.onlyRenderWidgetsInside = value;
    }

    public boolean getOnlyInteractWithWidgetsInside() {
        return this.onlyInteractWithWidgetsInside;
    }

    public void setOnlyInteractWithWidgetsInside(boolean value) {
        this.onlyInteractWithWidgetsInside = value;
    }

    public abstract void addWidgets();

    public abstract void alignWidgets();

    public void refreshWidgets() {
        this.widgets.clear();
        this.pushFontUnicode(this.getUnicode());
        try {
            this.addWidgets();
        }
        catch (MismatchingParentPanelException ex) {
            FTBLib.LOGGER.error(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.alignWidgets();
        for (Widget widget : this.widgets) {
            if (!(widget instanceof Panel)) continue;
            ((Panel)widget).refreshWidgets();
        }
        this.alignWidgets();
        this.popFontUnicode();
    }

    public void add(Widget widget) {
        if (widget.parent != this) {
            throw new MismatchingParentPanelException(this, widget);
        }
        this.widgets.add(widget);
    }

    public void addAll(Iterable<? extends Widget> list) {
        for (Widget widget : list) {
            this.add(widget);
        }
    }

    protected final int align(WidgetLayout layout) {
        return layout.align(this);
    }

    @Override
    public int getAX() {
        return super.getAX() + this.offsetX;
    }

    @Override
    public int getAY() {
        return super.getAY() + this.offsetY;
    }

    public void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = -this.scrollX;
            this.offsetY = -this.scrollY;
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    public boolean isOffset() {
        return this.offsetX != 0 || this.offsetY != 0;
    }

    public void setScrollX(int scroll) {
        this.scrollX = scroll;
    }

    public void setScrollY(int scroll) {
        this.scrollY = scroll;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    @Override
    public void draw() {
        boolean renderInside = this.getOnlyRenderWidgetsInside();
        this.pushFontUnicode(this.getUnicode());
        int ax = this.getAX();
        int ay = this.getAY();
        this.drawPanelBackground(ax, ay);
        if (renderInside) {
            GuiHelper.pushScissor(this.getScreen(), ax, ay, this.width, this.height);
        }
        this.setOffset(true);
        this.drawOffsetPanelBackground(ax + this.offsetX, ay + this.offsetY);
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldDraw() || renderInside && !widget.collidesWith(ax, ay, this.width, this.height)) continue;
            this.drawWidget(widget, i, ax + this.offsetX, ay + this.offsetY, this.width, this.height);
        }
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor(this.getScreen());
        }
        this.popFontUnicode();
    }

    protected void drawPanelBackground(int ax, int ay) {
        this.getIcon().draw(ax, ay, this.width, this.height);
    }

    protected void drawOffsetPanelBackground(int ax, int ay) {
    }

    protected void drawWidget(Widget widget, int index, int ax, int ay, int w, int h) {
        widget.draw();
        if (GuiBase.renderDebugBoxes) {
            Color4I col = Color4I.rgb(Color.HSBtoRGB((float)(widget.hashCode() & 0xFF) / 255.0f, 1.0f, 1.0f));
            GuiHelper.drawHollowRect(widget.getAX(), widget.getAY(), widget.width, widget.height, col.withAlpha(150), false);
            col.withAlpha(30).draw(widget.getAX() + 1, widget.getAY() + 1, widget.width - 2, widget.height - 2);
        }
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return;
        }
        this.pushFontUnicode(this.getUnicode());
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldAddMouseOverText()) continue;
            widget.addMouseOverText(list);
            if (!GuiBase.renderDebugBoxes) continue;
            list.add(TextFormatting.DARK_GRAY + widget.getClass().getSimpleName() + ": " + widget.width + "x" + widget.height);
        }
        this.setOffset(false);
        this.popFontUnicode();
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        this.setOffset(true);
        for (Widget widget : this.widgets) {
            widget.updateMouseOver(mouseX, mouseY);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return false;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mousePressed(button)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void mouseReleased(MouseButton button) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.mouseReleased(button);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mouseScrolled(int scroll) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mouseScrolled(scroll)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public boolean keyPressed(int key, char keyChar) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.keyPressed(key, keyChar)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void keyReleased(int key) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.keyReleased(key);
        }
        this.setOffset(false);
    }
}

