/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.TextField;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftblib.lib.util.text_components.TextComponentCountdown;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class ExtendedTextField
extends TextField {
    public ITextComponent textComponent;
    private List<GuiBase.PositionedTextData> textData;
    private long lastUpdate = -1L;

    public ExtendedTextField(GuiBase gui, ITextComponent t, int flags) {
        super(gui, "", flags);
        this.textComponent = t;
        this.setText("");
    }

    public ExtendedTextField(GuiBase gui, ITextComponent t) {
        this(gui, t, 0);
    }

    @Override
    public ExtendedTextField setText(String txt) {
        this.lastUpdate = -1L;
        if (this.textComponent != null) {
            for (ITextComponent component : this.textComponent) {
                if (!(component instanceof TextComponentCountdown)) continue;
                this.lastUpdate = 0L;
            }
            super.setText(this.textComponent.func_150254_d());
            this.textData = this.createDataFrom(this.textComponent, this.width);
        }
        return this;
    }

    @Nullable
    private GuiBase.PositionedTextData getDataAtMouse() {
        int ax = this.getAX();
        int ay = this.getAY();
        for (GuiBase.PositionedTextData data : this.textData) {
            if (!this.getGui().isMouseOver(data.posX + ax, data.posY + ay, data.width, data.height)) continue;
            return data;
        }
        return null;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        GuiBase.PositionedTextData data = this.getDataAtMouse();
        if (data != null && data.hoverEvent != null) {
            Collections.addAll(list, data.hoverEvent.func_150702_b().func_150254_d().split("\n"));
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        GuiBase.PositionedTextData data;
        if (this.isMouseOver() && (data = this.getDataAtMouse()) != null && data.clickEvent != null && this.handleClick(GuiHelper.clickEventToString(data.clickEvent))) {
            GuiHelper.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void draw() {
        long ms;
        if (this.lastUpdate != -1L && this.lastUpdate <= (ms = System.currentTimeMillis())) {
            this.lastUpdate = ms + 500L;
            this.setText("");
            this.parent.refreshWidgets();
        }
        super.draw();
    }
}

