/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.data;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.player.ForgePlayerConfigEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerDataEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.IHasCache;
import com.feed_the_beast.ftblib.lib.data.NBTDataStorage;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.EnumPrivacyLevel;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import net.minecraftforge.server.permission.context.WorldContext;

public class ForgePlayer
implements IStringSerializable,
INBTSerializable<NBTTagCompound>,
Comparable<ForgePlayer>,
IHasCache {
    private static FakePlayer playerForStats;
    private final UUID playerId;
    private String playerName;
    public final HashSet<ResourceLocation> firstLogin;
    public final NBTDataStorage dataStorage;
    public ForgeTeam team;
    private final ConfigBoolean hideTeamNotification;
    public EntityPlayerMP entityPlayer;
    public NBTTagCompound cachedPlayerNBT;
    private ConfigGroup cachedConfig;
    private GameProfile cachedProfile;
    public long lastTimeSeen;
    private IConfigCallback cachedConfigCallback;
    public boolean needsSaving;

    public ForgePlayer(Universe u, UUID id, String name) {
        this.playerId = id;
        this.playerName = name;
        this.firstLogin = new HashSet();
        this.dataStorage = new NBTDataStorage();
        this.team = u.getTeam("");
        this.hideTeamNotification = new ConfigBoolean();
        new ForgePlayerDataEvent(this, this.dataStorage::add).post();
        this.needsSaving = false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("HideTeamNotification", this.hideTeamNotification.getBoolean());
        nbt.func_74772_a("LastTimeSeen", this.lastTimeSeen);
        nbt.func_74782_a("Data", (NBTBase)this.dataStorage.serializeNBT());
        NBTTagList list = new NBTTagList();
        for (ResourceLocation id : this.firstLogin) {
            list.func_74742_a((NBTBase)new NBTTagString(id.toString()));
        }
        nbt.func_74782_a("FirstLogin", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.hideTeamNotification.setBoolean(nbt.func_74767_n("HideTeamNotification"));
        this.lastTimeSeen = nbt.func_74763_f("LastTimeSeen");
        this.dataStorage.deserializeNBT(nbt.func_74775_l("Data"));
        NBTTagList list = nbt.func_150295_c("FirstLogin", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.firstLogin.add(new ResourceLocation(list.func_150307_f(i)));
        }
    }

    @Override
    public void clearCache() {
        this.cachedPlayerNBT = null;
        this.cachedProfile = null;
        this.cachedConfig = null;
        this.cachedConfigCallback = null;
        this.dataStorage.clearCache();
    }

    public void markDirty() {
        this.needsSaving = true;
        this.team.universe.checkSaving = true;
    }

    public boolean hasTeam() {
        return this.team.isValid();
    }

    public final GameProfile getProfile() {
        if (this.isFake()) {
            return CommonUtils.FAKE_PLAYER_PROFILE;
        }
        if (this.isOnline()) {
            return this.entityPlayer.func_146103_bH();
        }
        if (this.cachedProfile == null) {
            this.cachedProfile = new GameProfile(this.playerId, this.playerName);
        }
        return this.cachedProfile;
    }

    public final UUID getId() {
        return this.playerId;
    }

    public final String func_176610_l() {
        return this.playerName;
    }

    public final void setName(String n) {
        if (!this.isFake() && !this.playerName.equals(n)) {
            new File(this.team.universe.getWorldDirectory(), "data/ftb_lib/players/" + this.playerName.toLowerCase() + ".dat").delete();
            this.playerName = n;
            this.markDirty();
        }
    }

    public final String getDisplayNameString() {
        return this.isOnline() ? this.getPlayer().getDisplayNameString() : this.func_176610_l();
    }

    public final ITextComponent getDisplayName() {
        return this.isOnline() ? this.getPlayer().func_145748_c_() : new TextComponentString(this.func_176610_l());
    }

    public EntityPlayerMP getCommandPlayer(ICommandSender sender) throws CommandException {
        if (!this.isOnline()) {
            throw FTBLib.error(sender, "player_must_be_online", new Object[0]);
        }
        return this.getPlayer();
    }

    public NBTDataStorage getData() {
        return this.dataStorage;
    }

    public boolean equalsPlayer(@Nullable ForgePlayer player) {
        return player == this || player != null && this.getId().equals(player.getId());
    }

    public boolean equalsPlayer(@Nullable ICommandSender player) {
        return player == this.entityPlayer || player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_110124_au().equals(this.getId());
    }

    @Override
    public final int compareTo(ForgePlayer o) {
        return StringUtils.IGNORE_CASE_COMPARATOR.compare(this.getDisplayNameString(), o.getDisplayNameString());
    }

    public final String toString() {
        return this.func_176610_l();
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ForgePlayer && this.equalsPlayer((ForgePlayer)o);
    }

    public boolean canInteract(@Nullable ForgePlayer owner, EnumPrivacyLevel level) {
        if (level == EnumPrivacyLevel.PUBLIC || owner == null) {
            return true;
        }
        if (owner.equalsPlayer(this)) {
            return true;
        }
        if (level == EnumPrivacyLevel.PRIVATE) {
            return false;
        }
        if (level == EnumPrivacyLevel.TEAM) {
            return owner.team.isAlly(this);
        }
        return false;
    }

    public boolean isOnline() {
        return this.entityPlayer != null;
    }

    public EntityPlayerMP getPlayer() {
        return Objects.requireNonNull(this.entityPlayer, "EntityPlayer can't be null!");
    }

    public boolean isFake() {
        return false;
    }

    public boolean isOP() {
        return ServerUtils.isOP(this.team.universe.server, this.getProfile());
    }

    public void onLoggedOut() {
        if (this.entityPlayer != null) {
            this.lastTimeSeen = this.entityPlayer.field_70170_p.func_82737_E();
            new ForgePlayerLoggedOutEvent(this).post();
            this.entityPlayer = null;
            this.clearCache();
            this.markDirty();
        }
    }

    public StatisticsManagerServer stats() {
        if (playerForStats == null) {
            playerForStats = new FakePlayer(this.team.universe.world, CommonUtils.FAKE_PLAYER_PROFILE);
        }
        playerForStats.func_70029_a((World)this.team.universe.world);
        playerForStats.func_184221_a(this.getId());
        return this.team.universe.server.func_184103_al().func_152602_a((EntityPlayer)playerForStats);
    }

    public ConfigGroup getSettings() {
        if (this.cachedConfig == null) {
            this.cachedConfig = new ConfigGroup((ITextComponent)new TextComponentTranslation("player_config", new Object[0]));
            this.cachedConfig.setSupergroup("player_config");
            ForgePlayerConfigEvent event = new ForgePlayerConfigEvent(this, this.cachedConfig);
            event.post();
            event.getConfig().setGroupName("ftblib", (ITextComponent)new TextComponentString("FTBLib"));
            event.getConfig().add("ftblib", "hide_team_notification", this.hideTeamNotification);
        }
        return this.cachedConfig;
    }

    public IConfigCallback getConfigCallback() {
        if (this.cachedConfigCallback == null) {
            this.cachedConfigCallback = (group, sender, json) -> {
                group.func_152753_a((JsonElement)json);
                this.clearCache();
                this.markDirty();
            };
        }
        return this.cachedConfigCallback;
    }

    public NBTTagCompound getPlayerNBT() {
        if (this.isOnline()) {
            return this.getPlayer().serializeNBT();
        }
        if (this.cachedPlayerNBT == null) {
            try (FileInputStream stream = new FileInputStream(new File(this.team.universe.getWorldDirectory(), "playerdata/" + this.getId() + ".dat"));){
                this.cachedPlayerNBT = CompressedStreamTools.func_74796_a((InputStream)stream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.cachedPlayerNBT == null) {
            this.cachedPlayerNBT = new NBTTagCompound();
        }
        return this.cachedPlayerNBT;
    }

    public void setPlayerNBT(NBTTagCompound nbt) {
        if (this.isOnline()) {
            EntityPlayerMP player = this.getPlayer();
            player.deserializeNBT(nbt);
            if (player.func_70089_S()) {
                player.field_70170_p.func_72866_a((Entity)player, true);
            }
        } else {
            try (FileOutputStream stream = new FileOutputStream(new File(this.team.universe.getWorldDirectory(), "playerdata/" + this.getId() + ".dat"));){
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)stream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.markDirty();
    }

    public boolean hideTeamNotification() {
        return FTBLibConfig.teams.hide_team_notification || this.hideTeamNotification.getBoolean() || this.isFake();
    }

    public long getLastTimeSeen() {
        return this.isOnline() ? this.team.universe.ticks : this.lastTimeSeen;
    }

    public boolean hasPermission(String node, @Nullable IContext context) {
        return PermissionAPI.hasPermission((GameProfile)this.getProfile(), (String)node, (IContext)context);
    }

    public IContext getContext() {
        if (this.isOnline()) {
            return new PlayerContext((EntityPlayer)this.getPlayer());
        }
        return new WorldContext((World)this.team.universe.world);
    }

    public boolean hasPermission(String node) {
        return PermissionAPI.hasPermission((GameProfile)this.getProfile(), (String)node, (IContext)this.getContext());
    }

    public ConfigValue getRankConfig(Node node) {
        return RankConfigAPI.get(this.team.universe.server, this.getProfile(), node, this.getContext());
    }

    public boolean isFirstLogin(ResourceLocation id) {
        if (!this.firstLogin.contains(id)) {
            this.firstLogin.add(id);
            return true;
        }
        return false;
    }
}

