/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import net.minecraft.util.text.ITextComponent;

public class ConfigValueInfo
implements Comparable<ConfigValueInfo> {
    public static final int DISPLAY_NAME = 1;
    public static final int GROUP = 2;
    public static final int EXCLUDED = 4;
    public static final int HIDDEN = 8;
    public static final int CANT_EDIT = 16;
    public static final int USE_SCROLL_BAR = 32;
    public final Node id;
    public String group;
    public ConfigValue defaultValue;
    public ITextComponent displayName;
    public boolean excluded;
    public boolean hidden;
    public boolean cantEdit;
    public boolean useScrollBar;

    public ConfigValueInfo(Node _id) {
        this.id = _id;
        this.setDefaults();
    }

    public ConfigValueInfo(Node id, ConfigValue _defaultValue) {
        this(id);
        this.defaultValue = _defaultValue;
    }

    public ConfigValueInfo(String _group, String _id, ConfigValue _defaultValue) {
        this(Node.get(_group.isEmpty() ? _id : _group + "." + _id), _defaultValue.copy());
        this.group = _group;
    }

    public void setDefaults() {
        this.group = "";
        this.displayName = null;
        this.defaultValue = ConfigNull.INSTANCE;
        this.excluded = false;
        this.hidden = false;
        this.cantEdit = false;
        this.useScrollBar = false;
    }

    public void writeData(DataOut net) {
        int flags = 0;
        flags = Bits.setFlag(flags, 1, this.displayName != null);
        flags = Bits.setFlag(flags, 2, !this.group.isEmpty());
        flags = Bits.setFlag(flags, 4, this.excluded);
        flags = Bits.setFlag(flags, 8, this.hidden);
        flags = Bits.setFlag(flags, 16, this.cantEdit);
        flags = Bits.setFlag(flags, 32, this.useScrollBar);
        net.writeByte(flags);
        if (this.displayName != null) {
            net.writeTextComponent(this.displayName);
        }
        if (!this.group.isEmpty()) {
            net.writeString(this.group);
        }
        net.writeString(this.defaultValue.func_176610_l());
        this.defaultValue.writeData(net);
    }

    public void readData(DataIn net) {
        this.setDefaults();
        short flags = net.readUnsignedByte();
        this.excluded = Bits.getFlag(flags, 4);
        this.hidden = Bits.getFlag(flags, 8);
        this.cantEdit = Bits.getFlag(flags, 16);
        this.useScrollBar = Bits.getFlag(flags, 32);
        if (Bits.getFlag(flags, 1)) {
            this.displayName = net.readTextComponent();
        }
        if (Bits.getFlag(flags, 2)) {
            this.group = net.readString();
        }
        this.defaultValue = FTBLibAPI.getConfigValueFromId(net.readString());
        this.defaultValue.readData(net);
    }

    public ConfigValueInfo copy() {
        ConfigValueInfo info = new ConfigValueInfo(this.id);
        info.defaultValue = this.defaultValue.copy();
        info.group = this.group;
        info.displayName = this.displayName == null ? null : this.displayName.func_150259_f();
        info.excluded = this.excluded;
        info.hidden = this.hidden;
        info.cantEdit = this.cantEdit;
        info.useScrollBar = this.useScrollBar;
        return info;
    }

    public ConfigValueInfo setDisplayName(ITextComponent name) {
        this.displayName = name;
        return this;
    }

    public String toString() {
        return this.id.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ConfigValueInfo && this.id.equals(((ConfigValueInfo)o).id);
    }

    @Override
    public int compareTo(ConfigValueInfo o) {
        return this.id.compareTo(o.id);
    }
}

