/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.LongSupplier;
import net.minecraft.util.text.TextFormatting;

public class ConfigTimer
extends ConfigValue
implements LongSupplier {
    public static final String ID = "timer";
    private long value;
    private long maxValue = Long.MAX_VALUE;

    public ConfigTimer() {
    }

    public ConfigTimer(long v) {
        this.value = v;
    }

    public ConfigTimer(long v, long max) {
        this(v);
        this.maxValue = max;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public Object getValue() {
        return this.getInt();
    }

    public ConfigTimer setMax(long v) {
        this.maxValue = v;
        return this;
    }

    public long getMax() {
        return this.maxValue;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    public void setTimer(long v) {
        this.value = v < 0L ? 0L : (v > this.getMax() ? this.getMax() : v);
    }

    @Override
    public String getString() {
        return Ticks.toString(this.getLong());
    }

    @Override
    public boolean getBoolean() {
        return this.getLong() > 0L;
    }

    @Override
    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public double getDouble() {
        return this.getLong();
    }

    @Override
    public ConfigTimer copy() {
        return new ConfigTimer(this.getInt(), this.getMax());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return value instanceof ConfigTimer && this.getLong() == value.getLong();
    }

    @Override
    public Color4I getColor() {
        return ConfigInt.COLOR;
    }

    @Override
    public void addInfo(ConfigValueInfo info, List<String> list) {
        super.addInfo(info, list);
        long m = this.getMax();
        if (m != Long.MAX_VALUE) {
            list.add(TextFormatting.AQUA + "Max: " + Ticks.toString(m));
        }
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        if (text.isEmpty()) {
            return false;
        }
        try {
            this.value = Ticks.fromString(text);
            if (!simulate) {
                this.setTimer(this.value);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void func_152753_a(JsonElement json) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            this.setTimer(json.getAsLong());
        } else {
            this.setTimer(0L);
            this.setValueFromString(json.getAsString(), false);
        }
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive(Ticks.toString(this.getLong()));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeLong(this.getLong());
        data.writeLong(this.getMax());
    }

    @Override
    public void readData(DataIn data) {
        this.setTimer(data.readLong());
        this.setMax(data.readLong());
    }

    @Override
    public long getAsLong() {
        return this.getLong();
    }
}

