/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.block;

import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBase
extends Block {
    public BlockBase(String mod, String id, Material material, MapColor color) {
        super(material, color);
        this.setRegistryName(mod, id);
        this.func_149663_c(mod + '.' + id);
        this.func_149711_c(1.8f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    public boolean dropSpecial(IBlockState state) {
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tileEntity;
        if (this.dropSpecial(state) && (tileEntity = world.func_175625_s(pos)) instanceof TileBase) {
            ((TileBase)tileEntity).destroyedByCreativePlayer = player.field_71075_bZ.field_75098_d;
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!this.dropSpecial(state)) {
            super.func_180653_a(world, pos, state, chance, fortune);
        }
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return this.isNormalCube(state, world, pos) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity;
        if (this.dropSpecial(state) && (tileEntity = world.func_175625_s(pos)) instanceof TileBase) {
            TileBase tile = (TileBase)tileEntity;
            if (!tile.destroyedByCreativePlayer || tile.shouldDrop()) {
                ItemStack stack = this.createStack(state, tileEntity);
                if (CommonUtils.hasBlockData(stack)) {
                    NBTTagCompound displayTag = new NBTTagCompound();
                    NBTTagList loreList = new NBTTagList();
                    loreList.func_74742_a((NBTBase)new NBTTagString("(+NBT)"));
                    displayTag.func_74782_a("Lore", (NBTBase)loreList);
                    stack.func_77983_a("display", (NBTBase)displayTag);
                }
                BlockBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            if (tile.updateComparator()) {
                world.func_175666_e(pos, state.func_177230_c());
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public ItemStack createStack(IBlockState state, @Nullable TileEntity tile) {
        NBTTagCompound nbt;
        ItemStack stack = new ItemStack((Block)this);
        if (this.dropSpecial(state) && tile instanceof TileBase && !(nbt = ((TileBase)tile).createItemData()).func_82582_d()) {
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity;
        if (world.field_72995_K && stack.func_77942_o() && this.hasTileEntity(state) && CommonUtils.hasBlockData(stack) && (tileEntity = world.func_175625_s(pos)) != null) {
            tileEntity.handleUpdateTag(CommonUtils.getBlockData(stack));
        }
    }
}

