/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.config.IGuiEditConfig;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.SimpleButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.MutableColor4I;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GuiEditConfig
extends GuiBase
implements IGuiEditConfig {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba(-1724697805);
    public static Theme THEME = new Theme(){

        @Override
        public Icon getGui(WidgetType type) {
            return Icon.EMPTY;
        }

        @Override
        public Icon getScrollBarBackground(WidgetType type) {
            return Color4I.BLACK.withAlpha(70);
        }

        @Override
        public Icon getScrollBar(WidgetType type, boolean vertical) {
            return this.getContentColor(WidgetType.NORMAL).withAlpha(100).withOutline(Color4I.GRAY.withAlpha(100), false);
        }
    };
    private final ConfigGroup group;
    private final IConfigCallback callback;
    private final JsonObject modifiedConfig;
    private final String title;
    private final List<Widget> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int shouldClose = 0;

    public GuiEditConfig(ConfigGroup g, IConfigCallback c) {
        this.group = g;
        this.callback = c;
        ITextComponent title0 = g.getTitle().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d();
        this.modifiedConfig = new JsonObject();
        this.configEntryButtons = new ArrayList<Widget>();
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (Widget w : GuiEditConfig.this.configEntryButtons) {
                    if (w instanceof ButtonConfigEntry && ((ButtonConfigEntry)w).group.collapsed) continue;
                    this.add(w);
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setPosAndSize(0, 0, this.width - 16, 16);
                }
                GuiEditConfig.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        ArrayList<ConfigValueInstance> list = new ArrayList<ConfigValueInstance>();
        for (ConfigValueInstance instance : this.group.getMap().values()) {
            if (instance.info.hidden) continue;
            list.add(instance);
        }
        if (!list.isEmpty()) {
            list.sort((o1, o2) -> {
                int i = o1.info.group.compareToIgnoreCase(o2.info.group);
                return i == 0 ? this.group.getDisplayName(o1.info).func_150260_c().compareToIgnoreCase(this.group.getDisplayName(o2.info).func_150260_c()) : i;
            });
            ButtonConfigGroup group = null;
            for (ConfigValueInstance instance : list) {
                if (group == null || !group.groupId.equalsIgnoreCase(instance.info.group)) {
                    group = new ButtonConfigGroup(this.configPanel, instance.info.group);
                    this.configEntryButtons.add(group);
                }
                this.configEntryButtons.add(new ButtonConfigEntry(this.configPanel, group, instance.info, instance.value.copy()));
            }
        }
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), GuiIcons.ACCEPT, (widget, button) -> {
            this.shouldClose = 1;
            widget.getGui().closeGui();
        });
        this.buttonCancel = new SimpleButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), GuiIcons.CANCEL, (widget, button) -> {
            this.shouldClose = 2;
            widget.getGui().closeGui();
        });
        this.buttonExpandAll = new SimpleButton(this, I18n.func_135052_a((String)"gui.expand_all", (Object[])new Object[0]), GuiIcons.ADD, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ButtonConfigGroup)) continue;
                ((ButtonConfigGroup)w).setCollapsed(false);
            }
            this.scroll.setValue(0);
            widget.getGui().refreshWidgets();
        });
        this.buttonCollapseAll = new SimpleButton(this, I18n.func_135052_a((String)"gui.collapse_all", (Object[])new Object[0]), GuiIcons.REMOVE, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ButtonConfigGroup)) continue;
                ((ButtonConfigGroup)w).setCollapsed(true);
            }
            this.scroll.setValue(0);
            widget.getGui().refreshWidgets();
        });
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.buttonExpandAll);
        this.add(this.buttonCollapseAll);
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
        this.buttonExpandAll.setPos(this.width - 58, 2);
        this.buttonCollapseAll.setPos(this.width - 78, 2);
    }

    @Override
    public void onClosed() {
        if (this.shouldClose == 1 && !this.modifiedConfig.entrySet().isEmpty()) {
            this.callback.saveConfig(this.group, (ICommandSender)ClientUtils.MC.field_71439_g, this.modifiedConfig);
        }
    }

    @Override
    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            this.buttonCancel.onClicked(MouseButton.LEFT);
        }
        return false;
    }

    @Override
    public void onChanged(Node key, JsonElement val) {
        this.modifiedConfig.add(key.toString(), val);
    }

    @Override
    public void drawBackground() {
        COLOR_BACKGROUND.draw(0, 0, this.width, 20);
        this.drawString(this.getTitle(), 5, 6, Color4I.DARK_GRAY, 0);
        this.drawString(this.getTitle(), 7, 6, Color4I.DARK_GRAY, 0);
        this.drawString(this.getTitle(), 6, 5, Color4I.DARK_GRAY, 0);
        this.drawString(this.getTitle(), 6, 7, Color4I.DARK_GRAY, 0);
        this.drawString(this.getTitle(), 6, 6);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Theme createTheme() {
        return THEME;
    }

    public class ButtonConfigEntry
    extends Button {
        public final ButtonConfigGroup group;
        public final ConfigValueInfo info;
        public final ConfigValue value;
        public String keyText;
        public List<String> infoText;

        public ButtonConfigEntry(Panel panel, ButtonConfigGroup g, ConfigValueInfo i, ConfigValue e) {
            String infoText;
            super(panel);
            this.group = g;
            this.info = i;
            this.value = e;
            ITextComponent keyLang = GuiEditConfig.this.group.getDisplayName(this.info);
            this.keyText = keyLang.func_150254_d();
            String string = infoText = keyLang instanceof TextComponentTranslation && I18n.func_188566_a((String)(((TextComponentTranslation)keyLang).func_150268_i() + ".tooltip")) ? I18n.func_135052_a((String)(((TextComponentTranslation)keyLang).func_150268_i() + ".tooltip"), (Object[])new Object[0]) : "";
            if (!infoText.isEmpty()) {
                this.infoText = new ArrayList<String>();
                for (String s : infoText.split("\\\\n")) {
                    this.infoText.addAll(this.listFormattedStringToWidth(s, 230));
                }
            }
            if (this.infoText == null || this.infoText.isEmpty()) {
                this.infoText = Collections.emptyList();
            }
        }

        @Override
        public void draw() {
            boolean mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            int ax = this.getAX();
            int ay = this.getAY();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(ax, ay, this.width, this.height);
            }
            this.drawString(this.keyText, ax + 4, ay + 4, Bits.setFlag(0, 2, mouseOver));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String s = this.value.toString();
            int slen = this.getStringWidth(s);
            if (slen > 150) {
                s = this.trimStringToWidth(s, 150, false) + "...";
                slen = 152;
            }
            MutableColor4I textCol = this.value.getColor().mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (this.getMouseX() > ax + this.width - slen - 9) {
                    Color4I.WHITE.withAlpha(33).draw(ax + this.width - slen - 8, ay, slen + 8, this.height);
                }
            }
            this.drawString(s, this.getGui().width - (slen + 20), ay + 4, textCol, 0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseY() >= 20 && !this.info.cantEdit) {
                GuiHelper.playClickSound();
                this.value.onClicked(GuiEditConfig.this, this.info, button);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (this.getMouseY() > 18) {
                if (!this.infoText.isEmpty() && this.getMouseX() < this.getAX() + this.getStringWidth(this.keyText) + 10) {
                    list.addAll(this.infoText);
                }
                if (this.getMouseX() > this.getGui().width - (Math.min(150, this.getStringWidth(this.value.getString())) + 25)) {
                    this.value.addInfo(this.info, list);
                }
            }
        }
    }

    public class ButtonConfigGroup
    extends Button {
        public final String groupId;
        public String title;
        public String info;
        public boolean collapsed;

        public ButtonConfigGroup(Panel panel, String id) {
            super(panel);
            this.title = "-";
            this.info = "";
            this.collapsed = false;
            this.groupId = id;
            if (!this.groupId.isEmpty()) {
                StringBuilder current = new StringBuilder();
                StringBuilder text = new StringBuilder();
                String[] sa = this.groupId.split("\\.");
                for (int i = 0; i < sa.length; ++i) {
                    if (i != 0) {
                        current.append(".");
                    }
                    current.append(sa[i]);
                    String key = current.toString();
                    text.append(GuiEditConfig.this.group.getGroupName(key).func_150254_d());
                    if (i == sa.length - 1) continue;
                    text.append(" > ");
                }
                this.title = text.toString();
                text.setLength(0);
                text.append(this.groupId);
                text.append(".info");
                String infoKey = text.toString();
                if (I18n.func_188566_a((String)infoKey)) {
                    this.info = I18n.func_135052_a((String)infoKey, (Object[])new Object[0]);
                }
            }
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean v) {
            this.collapsed = v;
            this.setTitle((this.collapsed ? TextFormatting.RED + "[-] " : TextFormatting.GREEN + "[v] ") + TextFormatting.RESET + this.title);
        }

        @Override
        public void draw() {
            int ax = this.getAX();
            int ay = this.getAY();
            COLOR_BACKGROUND.draw(ax, ay, this.width, this.height);
            this.drawString(this.getTitle(), ax + 3, ay + 4);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(ax, ay, this.width, this.height);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (!this.info.isEmpty()) {
                list.add(this.info);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }
    }
}

