/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.RegisterAdminPanelActionsEvent;
import com.feed_the_beast.ftblib.events.RegisterConfigValueProvidersEvent;
import com.feed_the_beast.ftblib.events.ServerReloadEvent;
import com.feed_the_beast.ftblib.events.team.RegisterTeamGuiActionsEvent;
import com.feed_the_beast.ftblib.lib.EnumReloadType;
import com.feed_the_beast.ftblib.lib.EventHandler;
import com.feed_the_beast.ftblib.lib.config.ConfigBlockState;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigColor;
import com.feed_the_beast.ftblib.lib.config.ConfigDouble;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigStringEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigTextComponent;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigTristate;
import com.feed_the_beast.ftblib.lib.data.Action;
import com.feed_the_beast.ftblib.lib.data.AdminPanelAction;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.FTBLibTeamGuiActions;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@EventHandler
public class FTBLibEventHandler {
    public static final ResourceLocation RELOAD_CONFIG = new ResourceLocation("ftblib", "config");

    @SubscribeEvent
    public static void registerConfigValueProviders(RegisterConfigValueProvidersEvent event) {
        event.register("null", () -> ConfigNull.INSTANCE);
        event.register("list", () -> new ConfigList("null"));
        event.register("bool", ConfigBoolean::new);
        event.register("tristate", ConfigTristate::new);
        event.register("int", ConfigInt::new);
        event.register("double", ConfigDouble::new);
        event.register("string", ConfigString::new);
        event.register("color", ConfigColor::new);
        event.register("enum", ConfigStringEnum::new);
        event.register("blockstate", ConfigBlockState::new);
        event.register("item_stack", ConfigItemStack::new);
        event.register("text_component", ConfigTextComponent::new);
        event.register("timer", ConfigTimer::new);
    }

    @SubscribeEvent
    public static void registerTeamGuiActions(RegisterTeamGuiActionsEvent event) {
        event.register(FTBLibTeamGuiActions.CONFIG);
        event.register(FTBLibTeamGuiActions.INFO);
        event.register(FTBLibTeamGuiActions.MEMBERS);
        event.register(FTBLibTeamGuiActions.ALLIES);
        event.register(FTBLibTeamGuiActions.MODERATORS);
        event.register(FTBLibTeamGuiActions.ENEMIES);
        event.register(FTBLibTeamGuiActions.LEAVE);
        event.register(FTBLibTeamGuiActions.TRANSFER_OWNERSHIP);
    }

    @SubscribeEvent
    public static void registerAdminPanelActions(RegisterAdminPanelActionsEvent event) {
        event.register(new AdminPanelAction("ftblib", "reload", GuiIcons.REFRESH, -1000){

            @Override
            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean(player.isOP());
            }

            @Override
            public void onAction(ForgePlayer player, NBTTagCompound data) {
                FTBLibAPI.reloadServer(player.team.universe, (ICommandSender)player.getPlayer(), EnumReloadType.RELOAD_COMMAND, ServerReloadEvent.ALL);
            }
        }.setTitle((ITextComponent)new TextComponentTranslation("ftblib.lang.reload_server_button", new Object[0])));
    }

    @SubscribeEvent
    public static void registerReloadIds(ServerReloadEvent.RegisterIds event) {
        event.register(RELOAD_CONFIG);
    }

    @SubscribeEvent
    public static void onServerReload(ServerReloadEvent event) {
        if (event.reload(RELOAD_CONFIG)) {
            FTBLibConfig.sync();
        }
    }
}

