/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.crafting.factories.AlkahestryCraftingRecipeFactory;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemInfernalTear
extends ItemToggleable {
    public ItemInfernalTear() {
        super("infernal_tear");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean flag) {
        if (world.field_72995_K || !this.isEnabled(ist)) {
            return;
        }
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        if (this.getStackFromTear(ist).func_190926_b()) {
            this.resetTear(ist);
            return;
        }
        AlkahestryCraftingRecipeFactory.AlkahestryCraftingRecipe recipe = this.matchAlkahestryRecipe(this.getStackFromTear(ist));
        if (recipe == null) {
            this.resetTear(ist);
            return;
        }
        if ((recipe.func_77571_b().func_190916_E() != 33 || recipe.getChargeNeeded() != 4) && InventoryHelper.consumeItem(this.getStackFromTear(ist), player)) {
            player.func_71023_q((int)Math.ceil((double)recipe.getChargeNeeded() / (double)(recipe.func_77571_b().func_190916_E() - 1) / 256.0 * 500.0));
        }
    }

    private AlkahestryCraftingRecipeFactory.AlkahestryCraftingRecipe matchAlkahestryRecipe(ItemStack stack) {
        for (AlkahestryCraftingRecipeFactory.AlkahestryCraftingRecipe recipe : XRRecipes.craftingRecipes) {
            if (!recipe.getInput().apply(stack)) continue;
            return recipe;
        }
        return null;
    }

    private void resetTear(ItemStack ist) {
        NBTTagCompound tag = ist.func_77978_p();
        if (tag != null) {
            tag.func_82580_o("item");
            tag.func_82580_o("enabled");
        }
    }

    @Override
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<String> tooltip) {
        if (this.getStackFromTear(stack).func_190926_b()) {
            LanguageHelper.formatTooltip("tooltip.infernal_tear.tear_empty", null, tooltip);
        } else {
            ItemStack contents = this.getStackFromTear(stack);
            String itemName = contents.func_82833_r();
            LanguageHelper.formatTooltip("tooltip.tear", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)itemName), tooltip);
            if (this.isEnabled(stack)) {
                LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + itemName)), tooltip);
            }
            tooltip.add(LanguageHelper.getLocalization("tooltip.absorb", new Object[0]));
            tooltip.add(LanguageHelper.getLocalization("tooltip.infernal_tear.absorb_unset", new Object[0]));
        }
    }

    @Nonnull
    public ItemStack getStackFromTear(@Nonnull ItemStack tear) {
        NBTTagCompound itemNBT = NBTHelper.getTagCompound("item", tear);
        if (itemNBT.func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(itemNBT);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack returnStack;
        ItemStack stack = player.func_184586_b(hand);
        ActionResult<ItemStack> actionResult = super.func_77659_a(world, player, hand);
        if (player.func_70093_af() && !this.isEnabled(stack)) {
            return actionResult;
        }
        ItemStack itemStack = (ItemStack)actionResult.func_188398_b();
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (!player.func_70093_af() && !this.getStackFromTear(itemStack).func_190926_b()) {
            NBTHelper.removeTag(nbt, "item");
            NBTHelper.removeTag(nbt, "enabled");
            return actionResult;
        }
        if (!this.getStackFromTear(itemStack).func_190926_b()) {
            return actionResult;
        }
        if (!(!player.func_70093_af() && this.isEnabled(itemStack) || (returnStack = this.buildTear(itemStack, (IInventory)player.field_71071_by)).func_190926_b())) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)returnStack);
        }
        if (this.isEnabled(itemStack)) {
            this.toggleEnabled(itemStack);
        }
        return actionResult;
    }

    @Nonnull
    private ItemStack buildTear(@Nonnull ItemStack stack, IInventory inventory) {
        ItemStack tear = new ItemStack((Item)this, 1);
        ItemStack target = this.getTargetAlkahestItem(stack, inventory);
        if (target.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        NBTHelper.setTagCompound("item", tear, target.func_77955_b(new NBTTagCompound()));
        if (Settings.Items.InfernalTear.absorbWhenCreated) {
            NBTHelper.setBoolean("enabled", stack, true);
        }
        return tear;
    }

    @Nonnull
    private ItemStack getTargetAlkahestItem(@Nonnull ItemStack self, IInventory inventory) {
        ItemStack targetItem = ItemStack.field_190927_a;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            AlkahestryCraftingRecipeFactory.AlkahestryCraftingRecipe recipe;
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack.func_190926_b() || self.func_77969_a(stack) || stack.func_77976_d() == 1 || stack.func_77978_p() != null || (recipe = this.matchAlkahestryRecipe(stack)) == null || recipe.func_77571_b().func_190916_E() == 33 && recipe.getChargeNeeded() == 4 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
        }
        inventory.func_70296_d();
        return targetItem;
    }
}

