/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xreliquary.blocks.tile.TileEntityBase;
import xreliquary.util.InventoryHelper;

public class TileEntityPedestalPassive
extends TileEntityBase
implements IInventory {
    protected NonNullList<ItemStack> inventory;
    protected short slots = 1;
    private EnumDyeColor color = EnumDyeColor.RED;

    public TileEntityPedestalPassive() {
        this.inventory = NonNullList.func_191197_a((int)this.slots, (Object)ItemStack.field_190927_a);
    }

    public void dropPedestalInventory() {
        this.inventory.stream().filter(itemstack -> !itemstack.func_190926_b()).forEach(itemstack -> InventoryHelper.spawnItemStack(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), itemstack));
    }

    public void removeLastPedestalStack() {
        for (int i = this.slots - 1; i >= 0; --i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            ItemStack stack = ((ItemStack)this.inventory.get(i)).func_77946_l();
            this.func_70299_a(i, ItemStack.field_190927_a);
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            this.func_70296_d();
            EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
            this.field_145850_b.func_72838_d((Entity)itemEntity);
            break;
        }
    }

    public int func_70302_i_() {
        return this.slots;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        if (index < this.slots) {
            return this.decrStackInInventory(index, count);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack decrStackInInventory(int slot, int count) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            ItemStack stack = ((ItemStack)this.inventory.get(slot)).func_77979_a(count);
            if (((ItemStack)this.inventory.get(slot)).func_190926_b()) {
                this.notifyBlock();
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        if (index < this.slots) {
            ItemStack stack = ItemStackHelper.func_188383_a(this.inventory, (int)index);
            this.notifyBlock();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void notifyBlock() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList items = compound.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)new ItemStack(item));
        }
        this.color = EnumDyeColor.func_176764_b((int)compound.func_74762_e("color"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList items = new NBTTagList();
        for (int slot = 0; slot < this.inventory.size(); ++slot) {
            if (((ItemStack)this.inventory.get(slot)).func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            ((ItemStack)this.inventory.get(slot)).func_77955_b(item);
            item.func_74774_a("Slot", (byte)slot);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Items", (NBTBase)items);
        compound.func_74768_a("color", this.color.func_176765_a());
        return compound;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        if (index < this.slots) {
            this.inventory.set(index, (Object)stack);
            this.notifyBlock();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return false;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return index < this.slots;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return "container.tile_entity_pedestal";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString("Pedestal");
    }

    public EnumDyeColor getClothColor() {
        return this.color;
    }

    public void setColor(EnumDyeColor color) {
        this.color = color;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

