/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xreliquary.blocks.tile.TileEntityInventory;
import xreliquary.compat.waila.provider.IWailaDataChangeIndicator;
import xreliquary.init.ModItems;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class TileEntityMortar
extends TileEntityInventory
implements IWailaDataChangeIndicator {
    private static final int PESTLE_USAGE_MAX = 5;
    private int pestleUsedCounter = 0;
    private String customInventoryName;
    private boolean dataChanged = true;
    private long finishCoolDown;

    public TileEntityMortar() {
        super(3);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList items = tag.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte b0 = item.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.func_70302_i_()) continue;
            this.inventory.set((int)b0, (Object)new ItemStack(item));
        }
        this.pestleUsedCounter = tag.func_74765_d("pestleUsed");
        if (tag.func_150297_b("CustomName", 8)) {
            this.customInventoryName = tag.func_74779_i("CustomName");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("pestleUsed", (short)this.pestleUsedCounter);
        NBTTagList items = new NBTTagList();
        for (int slot = 0; slot < this.inventory.size(); ++slot) {
            if (((ItemStack)this.inventory.get(slot)).func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            ((ItemStack)this.inventory.get(slot)).func_77955_b(item);
            item.func_74774_a("Slot", (byte)slot);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Items", (NBTBase)items);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.func_70005_c_());
        }
        return compound;
    }

    public NonNullList<ItemStack> getItemStacks() {
        return this.inventory;
    }

    public boolean usePestle() {
        int itemCount = 0;
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        for (ItemStack item : this.getItemStacks()) {
            if (item.func_190926_b()) continue;
            ++itemCount;
            potionIngredients.add(XRPotionHelper.getIngredient(item));
        }
        if (itemCount > 1) {
            ++this.pestleUsedCounter;
            this.spawnPestleParticles();
        }
        if (this.pestleUsedCounter >= 5) {
            List<PotionEffect> resultEffects = XRPotionHelper.combineIngredients(potionIngredients);
            if (resultEffects.isEmpty()) {
                this.pestleUsedCounter = 0;
                for (int clearSlot = 0; clearSlot < this.func_70302_i_(); ++clearSlot) {
                    if (this.func_70301_a(clearSlot).func_190926_b()) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.func_70301_a(clearSlot).func_77946_l());
                        this.field_145850_b.func_72838_d((Entity)itemEntity);
                    }
                    this.func_70299_a(clearSlot, ItemStack.field_190927_a);
                }
            } else {
                for (int clearSlot = 0; clearSlot < this.func_70302_i_(); ++clearSlot) {
                    this.func_70299_a(clearSlot, ItemStack.field_190927_a);
                }
                this.pestleUsedCounter = 0;
                this.finishCoolDown = this.field_145850_b.func_82737_E() + 20L;
                if (this.field_145850_b.field_72995_K) {
                    return true;
                }
                ItemStack resultItem = new ItemStack((Item)ModItems.potionEssence, 1, 0);
                XRPotionHelper.addPotionEffectsToStack(resultItem, resultEffects);
                EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, resultItem);
                this.field_145850_b.func_72838_d((Entity)itemEntity);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private void spawnPestleParticles() {
        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.15, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.1, 0.0, new int[0]);
    }

    public boolean isInCooldown() {
        return this.field_145850_b.func_82737_E() < this.finishCoolDown;
    }

    @Override
    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.dataChanged = true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    @Override
    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack ist) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b() || !this.func_70301_a(i).func_77969_a(ist)) continue;
            return false;
        }
        return slot <= 3 && (XRPotionHelper.isItemIngredient(ist) || XRPotionHelper.isItemEssence(ist));
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customInventoryName : "container.tile_entity_mortar";
    }

    public boolean func_145818_k_() {
        return this.customInventoryName != null;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }
}

