/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xreliquary.blocks.BlockBase;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;

public class BlockApothecaryMortar
extends BlockBase {
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB MORTAR_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.4, 0.75);

    public BlockApothecaryMortar() {
        super(Material.field_151576_e, "apothecary_mortar", 1.5f, 2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB mask, @Nonnull List list, Entity collidingEntity, boolean p_185477_7_) {
        BlockApothecaryMortar.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, (List)list, (AxisAlignedBB)MORTAR_AABB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityMortar();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MORTAR_AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float xOff, float yOff, float zOff) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || !(tileEntity instanceof TileEntityMortar)) {
            return false;
        }
        TileEntityMortar mortar = (TileEntityMortar)tileEntity;
        if (heldItem.func_190926_b()) {
            if (player.func_70093_af()) {
                xreliquary.util.InventoryHelper.tryRemovingLastStack(mortar, world, mortar.func_174877_v());
                return true;
            }
            boolean done = mortar.usePestle();
            world.func_184133_a(null, pos, this.field_149762_H.func_185844_d(), SoundCategory.BLOCKS, (this.field_149762_H.func_185843_a() + 1.0f) / 2.0f, this.field_149762_H.func_185847_b() * 0.8f);
            player.func_184609_a(hand);
            return done;
        }
        if (mortar.isInCooldown() && heldItem.func_77973_b() == ModItems.potionEssence) {
            return false;
        }
        NonNullList<ItemStack> mortarItems = mortar.getItemStacks();
        boolean putItemInSlot = false;
        for (int slot = 0; slot < mortarItems.size(); ++slot) {
            ItemStack item = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77952_i());
            item.func_77982_d(heldItem.func_77978_p());
            if (!((ItemStack)mortarItems.get(slot)).func_190926_b() || !mortar.func_94041_b(slot, item)) continue;
            heldItem.func_190918_g(1);
            mortar.func_70299_a(slot, item);
            putItemInSlot = true;
            break;
        }
        if (!putItemInSlot) {
            mortar.usePestle();
            world.func_184133_a(null, pos, this.field_149762_H.func_185844_d(), SoundCategory.BLOCKS, (this.field_149762_H.func_185843_a() + 1.0f) / 2.0f, this.field_149762_H.func_185847_b() * 0.8f);
            return false;
        }
        mortar.func_70296_d();
        return true;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemBlock.func_150898_a((Block)ModBlocks.apothecaryMortar);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityMortar) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityMortar)tileentity));
        }
        super.func_180663_b(world, pos, state);
    }
}

