/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.proxy.block.BlockConveyor;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.MovementUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityConveyor
extends TileEntity
implements IConveyorContainer,
ITickable {
    private EnumFacing facing;
    private BlockConveyor.EnumType type;
    private int color = 0;
    private Map<EnumFacing, ConveyorUpgrade> upgradeMap = new HashMap<EnumFacing, ConveyorUpgrade>();
    private List<Integer> filter;
    private boolean sticky = false;

    public TileEntityConveyor() {
        this.facing = EnumFacing.NORTH;
        this.type = BlockConveyor.EnumType.FLAT;
        this.filter = new ArrayList<Integer>();
    }

    @Override
    public World getConveyorWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getConveyorPosition() {
        return this.func_174877_v();
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public boolean hasUpgrade(EnumFacing facing) {
        return this.upgradeMap.containsKey(facing);
    }

    public int getPower() {
        int highestPower = 0;
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            int power;
            if (upgrade == null || (power = upgrade.getRedstoneOutput()) <= highestPower) continue;
            highestPower = power;
        }
        return highestPower;
    }

    @Override
    public void addUpgrade(EnumFacing facing, ConveyorUpgradeFactory upgrade) {
        if (!this.hasUpgrade(facing)) {
            this.upgradeMap.put(facing, upgrade.create(this, facing));
            this.requestSync();
        }
    }

    @Override
    public void removeUpgrade(EnumFacing facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.field_145850_b.field_72995_K && drop) {
                ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                    item.func_92058_a(stack);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
            }
            this.upgradeMap.get(facing).onUpgradeRemoved();
            this.upgradeMap.remove(facing);
            this.requestSync();
        }
    }

    @Override
    public List<Integer> getEntityFilter() {
        return this.filter;
    }

    public void func_73660_a() {
        if (this.type.isVertical() && !this.upgradeMap.isEmpty()) {
            new ArrayList<EnumFacing>(this.upgradeMap.keySet()).forEach(facing1 -> this.removeUpgrade((EnumFacing)facing1, true));
        }
        this.upgradeMap.values().forEach(ConveyorUpgrade::update);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.markForUpdate();
    }

    public BlockConveyor.EnumType getType() {
        return this.type;
    }

    public void setType(BlockConveyor.EnumType type) {
        this.type = type;
        this.markForUpdate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markForUpdate();
    }

    public void setColor(EnumDyeColor color) {
        this.color = color.func_176767_b();
        this.markForUpdate();
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
        this.markForUpdate();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74778_a("Facing", this.facing.func_176610_l());
        compound.func_74778_a("Type", this.type.func_176610_l());
        compound.func_74768_a("Color", this.color);
        compound.func_74757_a("Sticky", this.sticky);
        NBTTagCompound upgrades = new NBTTagCompound();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.hasUpgrade(facing)) continue;
            NBTTagCompound upgradeTag = new NBTTagCompound();
            ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
            upgradeTag.func_74778_a("factory", upgrade.getFactory().getRegistryName().toString());
            NBTTagCompound customNBT = upgrade.serializeNBT();
            if (customNBT != null) {
                upgradeTag.func_74782_a("customNBT", (NBTBase)customNBT);
            }
            upgrades.func_74782_a(facing.func_176610_l(), (NBTBase)upgradeTag);
        }
        compound.func_74782_a("Upgrades", (NBTBase)upgrades);
        return compound;
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        this.field_145850_b = worldIn;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = EnumFacing.valueOf((String)compound.func_74779_i("Facing").toUpperCase());
        this.type = BlockConveyor.EnumType.valueOf(compound.func_74779_i("Type").toUpperCase());
        this.color = compound.func_74762_e("Color");
        this.sticky = compound.func_74767_n("Sticky");
        if (compound.func_150297_b("Upgrades", 10)) {
            NBTTagCompound upgradesTag = compound.func_74775_l("Upgrades");
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                NBTTagCompound upgradeTag;
                ConveyorUpgradeFactory factory;
                if (!upgradesTag.func_74764_b(facing.func_176610_l()) || (factory = (ConveyorUpgradeFactory)IFRegistries.CONVEYOR_UPGRADE_REGISTRY.getValue(new ResourceLocation((upgradeTag = upgradesTag.func_74775_l(facing.func_176610_l())).func_74779_i("factory")))) == null) continue;
                ConveyorUpgrade upgrade = this.upgradeMap.getOrDefault(facing, factory.create(this, facing));
                if (upgradeTag.func_150297_b("customNBT", 10)) {
                    upgrade.deserializeNBT(upgradeTag.func_74775_l("customNBT"));
                }
                this.upgradeMap.put(facing, upgrade);
            }
        }
    }

    public void markForUpdate() {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockConveyor.TYPE, (Comparable)((Object)this.type)).func_177226_a((IProperty)BlockConveyor.FACING, (Comparable)this.facing));
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_70296_d();
    }

    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        EnumFacing facing = this.facing;
        if (this.type.isDown()) {
            facing = facing.func_176734_d();
        }
        for (double height = 1.0; height > 0.0; height -= 0.1) {
            if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                boxes.add(new AxisAlignedBB(0.0, 0.0, facing == EnumFacing.NORTH ? 0.0 : 1.0 - height, 1.0, 1.0 - height, facing == EnumFacing.NORTH ? height : 1.0));
            }
            if (facing != EnumFacing.WEST && facing != EnumFacing.EAST) continue;
            boxes.add(new AxisAlignedBB(facing == EnumFacing.WEST ? 0.0 : 1.0 - height, 0.0, 0.0, facing == EnumFacing.WEST ? height : 1.0, 1.0 - height, 1.0));
        }
        return boxes;
    }

    public void handleEntityMovement(Entity entity) {
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            if (upgrade == null) continue;
            upgrade.handleEntity(entity);
        }
        if (!entity.field_70128_L) {
            if (!this.getEntityFilter().contains(entity.func_145782_y())) {
                MovementUtils.handleConveyorMovement(entity, this.facing, this.field_174879_c, this.type);
            }
            if (entity instanceof EntityItem && this.sticky) {
                ((EntityItem)entity).func_174867_a(5);
            }
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !oldState.func_177230_c().equals(newSate.func_177230_c());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public Map<EnumFacing, ConveyorUpgrade> getUpgradeMap() {
        return this.upgradeMap;
    }
}

