/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.bedbugs.client.event;

import gr8pefish.bedbugs.client.gui.KickButton;
import gr8pefish.bedbugs.common.BedBugs;
import gr8pefish.bedbugs.common.lib.Logger;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private KickButton kickButton;
    private boolean showButton;
    private long prevSystemShowButtonTime;
    private long showButtonTime;
    private final int visibleShowLimit = 250;
    private long prevSystemTooltipHoverTime;
    private long tooltipHoverTime;
    private final int hoverShowLimit = 1000;

    @SubscribeEvent
    public void onSleepGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiSleepMP) {
            List list = event.getButtonList();
            this.kickButton = new KickButton(event.getGui().field_146294_l / 2 - 30, event.getGui().field_146295_m - 70);
            this.kickButton.field_146125_m = false;
            event.getButtonList().add(this.kickButton);
            this.showButton = false;
            this.prevSystemShowButtonTime = 0L;
            this.showButtonTime = 0L;
            this.prevSystemTooltipHoverTime = 0L;
            this.tooltipHoverTime = 0L;
            event.setButtonList(list);
        }
    }

    @SubscribeEvent
    public void onClick(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getGui() instanceof GuiSleepMP) {
            if (event.getButton().field_146127_k == 1 && !this.showButton) {
                this.showButton = true;
            }
            if (event.getButton() instanceof KickButton) {
                BedBugs.proxy.handleKick(null);
            }
        }
    }

    @SubscribeEvent
    public void onHover(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiSleepMP) {
            this.handleCounter(this.showButton, 250, CounterType.SHOW_BUTTON, event);
            boolean hovering = this.kickButton != null && this.kickButton.field_146125_m && this.kickButton.isMouseInButton(event.getMouseX(), event.getMouseY());
            this.handleCounter(hovering, 1000, CounterType.SHOW_TOOLTIP, event);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) throws Throwable {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r != null && mc.field_71462_r instanceof GuiSleepMP && !mc.field_71439_g.func_70608_bn()) {
                try {
                    String[] INPUT_FIELD = new String[]{"inputField", "field_146415_a", "a"};
                    String typed = ((GuiTextField)ReflectionHelper.findField(GuiChat.class, (String[])INPUT_FIELD).get((GuiSleepMP)mc.field_71462_r)).func_146179_b();
                    if (!StringUtils.func_151246_b((String)typed)) {
                        mc.func_147108_a((GuiScreen)new GuiChat(typed));
                    }
                }
                catch (Exception e) {
                    Logger.fatal("Couldn't reflect GuiChat.inputField successfully. Chat won't persist through awakening.");
                }
            }
        }
    }

    private void handleCounter(boolean goOn, int timeLimit, CounterType counterType, GuiScreenEvent.DrawScreenEvent.Post event) {
        if (goOn) {
            long time = this.handleCounterSpecificsSystemTime(counterType, System.currentTimeMillis());
            if (time > (long)timeLimit && Minecraft.func_71410_x().field_71462_r instanceof GuiSleepMP) {
                this.handleCounterSpecificsDelegateMethod(counterType, event);
            }
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiSleepMP)) {
                this.handleCounterSpecificsNotGuiSleep(counterType);
            }
        } else {
            this.handleCounterSpecificsStop(counterType);
        }
    }

    private long handleCounterSpecificsSystemTime(CounterType counterType, long systemTime) {
        switch (counterType) {
            case SHOW_BUTTON: {
                if (this.prevSystemShowButtonTime != 0L) {
                    this.showButtonTime += systemTime - this.prevSystemShowButtonTime;
                }
                this.prevSystemShowButtonTime = systemTime;
                return this.showButtonTime;
            }
            case SHOW_TOOLTIP: {
                if (this.prevSystemTooltipHoverTime != 0L) {
                    this.tooltipHoverTime += systemTime - this.prevSystemTooltipHoverTime;
                }
                this.prevSystemTooltipHoverTime = systemTime;
                return this.tooltipHoverTime;
            }
        }
        return 0L;
    }

    private void handleCounterSpecificsDelegateMethod(CounterType counterType, GuiScreenEvent.DrawScreenEvent.Post event) {
        switch (counterType) {
            case SHOW_BUTTON: {
                this.kickButton.field_146125_m = true;
                break;
            }
            case SHOW_TOOLTIP: {
                GuiUtils.drawHoveringText(this.kickButton.getTooltipLines(), (int)event.getMouseX(), (int)event.getMouseY(), (int)event.getGui().field_146294_l, (int)event.getGui().field_146295_m, (int)300, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }
    }

    private void handleCounterSpecificsNotGuiSleep(CounterType counterType) {
        switch (counterType) {
            case SHOW_BUTTON: {
                this.showButton = false;
                this.showButtonTime = 0L;
                this.prevSystemShowButtonTime = 0L;
                break;
            }
        }
    }

    private void handleCounterSpecificsStop(CounterType counterType) {
        switch (counterType) {
            case SHOW_BUTTON: {
                this.showButtonTime = 0L;
                this.prevSystemShowButtonTime = 0L;
                break;
            }
            case SHOW_TOOLTIP: {
                this.tooltipHoverTime = 0L;
                this.prevSystemTooltipHoverTime = 0L;
            }
        }
    }

    private static enum CounterType {
        SHOW_BUTTON,
        SHOW_TOOLTIP;

    }
}

