/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.evaluate.variable;

import com.google.common.base.Optional;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.ThaumcraftModCompat;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class ValueObjectTypeAspect
extends ValueObjectTypeBase<ValueAspect>
implements IValueTypeNamed<ValueAspect> {
    private static final String DELIMITER = ";";

    public ValueObjectTypeAspect() {
        super("thaumcraftaspect");
    }

    @Override
    public ValueAspect getDefault() {
        return ValueAspect.ofNull();
    }

    @Override
    public String toCompactString(ValueAspect value) {
        Optional aspect = value.getRawValue();
        if (aspect.isPresent()) {
            return ((Aspect)((Pair)aspect.get()).getKey()).getName() + ":" + ((Pair)aspect.get()).getValue();
        }
        return "";
    }

    @Override
    public String serialize(ValueAspect value) {
        Optional aspect = value.getRawValue();
        if (aspect.isPresent()) {
            return ((Aspect)((Pair)aspect.get()).getKey()).getTag() + DELIMITER + ((Pair)aspect.get()).getValue();
        }
        return "";
    }

    @Override
    public ValueAspect deserialize(String value) {
        String[] split = value.split(DELIMITER);
        if (split.length == 2) {
            try {
                return ValueAspect.of(Aspect.getAspect((String)split[0]), Integer.parseInt(split[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ValueAspect.ofNull();
    }

    @Override
    public String getName(ValueAspect a) {
        Optional aspect = a.getRawValue();
        if (aspect.isPresent()) {
            return ((Aspect)((Pair)aspect.get()).getKey()).getName();
        }
        return "";
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueAspect>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueAspect>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public L10NHelpers.UnlocalizedString validate(ItemStack itemStack) {
                AspectList aspectList = AspectHelper.getObjectAspects((ItemStack)itemStack);
                return aspectList.size() != 0 ? null : new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.thaumcraftaspect.no_aspect", new Object[0]);
            }

            @Override
            public ValueAspect getValue(ItemStack itemStack) {
                AspectList aspectList = AspectHelper.getObjectAspects((ItemStack)itemStack);
                Aspect[] aspectArray = aspectList.getAspectsSortedByAmount();
                return ValueAspect.of(aspectArray[0], aspectList.getAmount(aspectArray[0]));
            }
        });
    }

    public static class ValueAspect
    extends ValueOptionalBase<Pair<Aspect, Integer>> {
        private ValueAspect(Aspect aspect, int amount) {
            super(ThaumcraftModCompat.OBJECT_ASPECT, Pair.of((Object)aspect, (Object)amount));
        }

        public ValueAspect() {
            super(ThaumcraftModCompat.OBJECT_ASPECT, null);
        }

        public static ValueAspect of(Aspect aspect, int amount) {
            return new ValueAspect(Objects.requireNonNull(aspect), amount);
        }

        public static ValueAspect ofNull() {
            return new ValueAspect();
        }

        @Override
        protected boolean isEqual(Pair<Aspect, Integer> a, Pair<Aspect, Integer> b) {
            return Objects.equals(((Aspect)a.getKey()).getTag(), ((Aspect)b.getKey()).getTag()) && Objects.equals(a.getValue(), b.getValue());
        }

        @Override
        public String toString() {
            return "ValueObjectTypeAspect.ValueAspect()";
        }
    }
}

