/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasin;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasinConfig;
import org.cyclops.integrateddynamics.core.tileentity.TileMechanicalMachine;

public class TileMechanicalDryingBasin
extends TileMechanicalMachine<Pair<ItemStack, FluidStack>, BlockMechanicalDryingBasin, IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> {
    private static final int SLOTS = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private final SingleUseTank tankIn = new SingleUseTank(10000, (TileEntity)this);
    private final SingleUseTank tankOut = new SingleUseTank(100000, (TileEntity)this);

    public TileMechanicalDryingBasin() {
        super(5);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP, this.tankIn);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN, this.tankOut);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.NORTH, this.tankIn);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.SOUTH, this.tankIn);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.WEST, this.tankIn);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.EAST, this.tankIn);
    }

    @Override
    protected SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties>>(){

            public IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> getNewValue(Pair<ItemStack, FluidStack> key) {
                IngredientAndFluidStackRecipeComponent recipeInput = new IngredientAndFluidStackRecipeComponent((ItemStack)key.getLeft(), (FluidStack)key.getRight());
                IRecipe maxRecipe = null;
                for (IRecipe recipe : TileMechanicalDryingBasin.this.getRecipeRegistry().findRecipesByInput((IRecipeInput)recipeInput)) {
                    if (key.getRight() == null) {
                        return recipe;
                    }
                    if (((FluidStack)key.getRight()).amount < ((IngredientAndFluidStackRecipeComponent)recipe.getInput()).getFluidStack().amount || maxRecipe != null && ((IngredientAndFluidStackRecipeComponent)recipe.getInput()).getFluidStack().amount <= ((IngredientAndFluidStackRecipeComponent)maxRecipe.getInput()).getFluidStack().amount) continue;
                    maxRecipe = recipe;
                }
                return maxRecipe;
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight())) && FluidHelpers.getAmount((FluidStack)((FluidStack)cacheKey.getRight())) == FluidHelpers.getAmount((FluidStack)((FluidStack)newKey.getRight()));
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockMechanicalDryingBasin.ON);
    }

    @Override
    public void setWorking(boolean working) {
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockMechanicalDryingBasin.ON, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTankInput() {
        return this.tankIn;
    }

    public SingleUseTank getTankOutput() {
        return this.tankOut;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.getTankInput().readFromNBT(tag.func_74775_l("tankIn"));
        this.getTankOutput().readFromNBT(tag.func_74775_l("tankOut"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("tankIn", (NBTBase)this.getTankInput().writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("tankOut", (NBTBase)this.getTankOutput().writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(tag);
    }

    @Override
    protected IRecipeRegistry<BlockMechanicalDryingBasin, IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> getRecipeRegistry() {
        return BlockMechanicalDryingBasin.getInstance().getRecipeRegistry();
    }

    @Override
    protected Pair<ItemStack, FluidStack> getCurrentRecipeCacheKey() {
        return Pair.of((Object)this.func_70301_a(0).func_77946_l(), (Object)FluidHelpers.copy((FluidStack)this.getTankInput().getFluid()));
    }

    @Override
    public IngredientAndFluidStackRecipeComponent getRecipeInput(NonNullList<ItemStack> inputStacks) {
        return new IngredientAndFluidStackRecipeComponent((ItemStack)inputStacks.get(0), FluidHelpers.copy((FluidStack)this.getTankInput().getFluid()));
    }

    @Override
    public int getRecipeDuration(IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> recipe) {
        return ((DurationRecipeProperties)recipe.getProperties()).getDuration();
    }

    @Override
    protected boolean finalizeRecipe(IRecipe<IngredientAndFluidStackRecipeComponent, IngredientAndFluidStackRecipeComponent, DurationRecipeProperties> recipe, boolean simulate) {
        FluidStack inputFluid;
        ItemStack outputStack = ((IngredientAndFluidStackRecipeComponent)recipe.getOutput()).getFirstItemStack().func_77946_l();
        if (!outputStack.func_190926_b() && !InventoryHelpers.addToInventory((IInventory)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)NonNullList.func_191197_a((int)1, (Object)outputStack), (boolean)simulate).isEmpty()) {
            return false;
        }
        FluidStack outputFluid = ((IngredientAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack();
        if (outputFluid != null && this.getTankOutput().fill(outputFluid.copy(), !simulate) != outputFluid.amount) {
            return false;
        }
        if (!simulate && !((IngredientAndFluidStackRecipeComponent)recipe.getInput()).getFirstItemStack().func_190926_b()) {
            this.func_70298_a(0, 1);
        }
        return (inputFluid = ((IngredientAndFluidStackRecipeComponent)recipe.getInput()).getFluidStack()) == null || FluidHelpers.getAmount((FluidStack)this.getTankInput().drain(inputFluid, !simulate)) == inputFluid.amount;
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalDryingBasinConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalDryingBasinConfig.capacity;
    }
}

