/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.remote;

import java.util.List;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.CreativeTab;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.helper.NBTHelper;
import mrriegel.storagenetwork.master.TileMaster;
import mrriegel.storagenetwork.request.TileRequest;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRemote
extends Item {
    public ItemRemote() {
        this.func_77637_a(CreativeTab.tab);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 2; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + stack.func_77952_i();
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)("tooltip.storagenetwork.remote_" + stack.func_77952_i()), (Object[])new Object[0]));
        if (stack.func_77942_o() && NBTHelper.getBoolean(stack, "bound")) {
            tooltip.add("Dimension: " + NBTHelper.getInteger(stack, "dim") + ", x: " + NBTHelper.getInteger(stack, "x") + ", y: " + NBTHelper.getInteger(stack, "y") + ", z: " + NBTHelper.getInteger(stack, "z"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        int x = NBTHelper.getInteger(itemStackIn, "x");
        int y = NBTHelper.getInteger(itemStackIn, "y");
        int z = NBTHelper.getInteger(itemStackIn, "z");
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(NBTHelper.getInteger(itemStackIn, "dim"));
        if (NBTHelper.getBoolean(itemStackIn, "bound") && world.func_175625_s(new BlockPos(x, y, z)) instanceof TileMaster) {
            if (itemStackIn.func_77952_i() == 0 && NBTHelper.getInteger(itemStackIn, "dim") == worldIn.field_73011_w.getDimension() && playerIn.func_70011_f((double)x, (double)y, (double)z) <= (double)ConfigHandler.rangeWirelessAccessor || itemStackIn.func_77952_i() == 1) {
                if (world.func_175726_f(new BlockPos(x, y, z)).func_177410_o()) {
                    if (NBTHelper.getString(itemStackIn, "sort") == null) {
                        NBTHelper.setString(itemStackIn, "sort", TileRequest.EnumSortType.NAME.toString());
                    }
                    playerIn.openGui((Object)StorageNetwork.instance, this.getGui(), (World)world, x, y, z);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
                }
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Cable Master not loaded."));
            } else if (itemStackIn.func_77952_i() == 0 && (NBTHelper.getInteger(itemStackIn, "dim") == worldIn.field_73011_w.getDimension() || playerIn.func_70011_f((double)x, (double)y, (double)z) > 32.0) && !worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Out of Range"));
            }
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.func_175625_s(pos) instanceof TileMaster) {
            NBTHelper.setInteger(stack, "x", pos.func_177958_n());
            NBTHelper.setInteger(stack, "y", pos.func_177956_o());
            NBTHelper.setInteger(stack, "z", pos.func_177952_p());
            NBTHelper.setBoolean(stack, "bound", true);
            NBTHelper.setInteger(stack, "dim", worldIn.field_73011_w.getDimension());
            NBTHelper.setString(stack, "sort", TileRequest.EnumSortType.NAME.toString());
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, side, hitX, hitY, hitZ);
    }

    protected int getGui() {
        return 4;
    }

    public static TileMaster getTile(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return null;
        }
        TileEntity t = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(NBTHelper.getInteger(stack, "dim")).func_175625_s(new BlockPos(NBTHelper.getInteger(stack, "x"), NBTHelper.getInteger(stack, "y"), NBTHelper.getInteger(stack, "z")));
        return t instanceof TileMaster ? (TileMaster)t : null;
    }

    public static void copyTag(ItemStack from, ItemStack to) {
        NBTHelper.setInteger(to, "x", NBTHelper.getInteger(from, "x"));
        NBTHelper.setInteger(to, "y", NBTHelper.getInteger(from, "y"));
        NBTHelper.setInteger(to, "z", NBTHelper.getInteger(from, "z"));
        NBTHelper.setBoolean(to, "bound", NBTHelper.getBoolean(from, "bound"));
        NBTHelper.setInteger(to, "dim", NBTHelper.getInteger(from, "dim"));
        NBTHelper.setString(to, "sort", NBTHelper.getString(from, "sort"));
    }
}

