/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.data.FilterItem;
import mrriegel.storagenetwork.data.StackWrapper;
import mrriegel.storagenetwork.gui.ContainerNetworkBase;
import mrriegel.storagenetwork.helper.UtilInventory;
import mrriegel.storagenetwork.master.TileMaster;
import mrriegel.storagenetwork.network.StacksMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeMessage
implements IMessage,
IMessageHandler<RecipeMessage, IMessage> {
    NBTTagCompound nbt;
    int index = 0;

    public RecipeMessage() {
    }

    public RecipeMessage(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.index = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        buf.writeInt(this.index);
    }

    public IMessage onMessage(final RecipeMessage message, final MessageContext ctx) {
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                Container c = ctx.getServerHandler().field_147369_b.field_71070_bA;
                StorageNetwork.log("new recipe packet. how do i tell if its an ore dict one " + message.nbt);
                if (c instanceof ContainerNetworkBase) {
                    ContainerNetworkBase ctr = (ContainerNetworkBase)c;
                    TileMaster master = ctr.getTileMaster();
                    InventoryCrafting craftMatrix = ctr.getCraftMatrix();
                    if (master == null) {
                        return;
                    }
                    block0: for (int slot = 0; slot < 9; ++slot) {
                        int i;
                        boolean isOreDict;
                        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
                        if (message.nbt.func_150297_b("s" + slot, 8)) {
                            isOreDict = true;
                            String[] oreDictKeys = message.nbt.func_74779_i("s" + slot).split(",");
                            ArrayList l = new ArrayList();
                            for (String oreKey : oreDictKeys) {
                                l.addAll(OreDictionary.getOres((String)oreKey));
                            }
                            for (i = 0; i < l.size(); ++i) {
                                map.put(i, l.get(i));
                            }
                            StorageNetwork.log(message.nbt.func_74779_i("s" + slot) + " ore dict keyS found  " + l);
                        } else {
                            isOreDict = false;
                            NBTTagList invList = message.nbt.func_150295_c("s" + slot, 10);
                            for (i = 0; i < invList.func_74745_c(); ++i) {
                                NBTTagCompound stackTag = invList.func_150305_b(i);
                                ItemStack s = new ItemStack(stackTag);
                                map.put(i, s);
                            }
                            StorageNetwork.log(slot + "   is ore stacks " + map.keySet());
                        }
                        for (int i2 = 0; i2 < map.size(); ++i2) {
                            ItemStack stackCurrent = (ItemStack)map.get(i2);
                            if (stackCurrent == null || stackCurrent.func_190926_b()) continue;
                            FilterItem filterItem = new FilterItem(stackCurrent);
                            filterItem.setOre(isOreDict);
                            StorageNetwork.log("CALL exctractItem   " + stackCurrent + " isOreDict " + isOreDict);
                            ItemStack ex = UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(ctx.getServerHandler().field_147369_b.field_71071_by), filterItem, 1, true);
                            if (ex != null && !ex.func_190926_b() && craftMatrix.func_70301_a(slot).func_190926_b()) {
                                UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(ctx.getServerHandler().field_147369_b.field_71071_by), filterItem, 1, false);
                                craftMatrix.func_70299_a(slot, ex);
                                continue block0;
                            }
                            if ((stackCurrent = master.request(!stackCurrent.func_190926_b() ? filterItem : null, 1, false)) == null || !craftMatrix.func_70301_a(slot).func_190926_b()) continue;
                            craftMatrix.func_70299_a(slot, stackCurrent);
                            continue block0;
                        }
                    }
                    ctr.slotChanged();
                    List<StackWrapper> list = master.getStacks();
                    PacketRegistry.INSTANCE.sendTo((IMessage)new StacksMessage(list, master.getCraftableStacks(list)), ctx.getServerHandler().field_147369_b);
                }
            }
        });
        return null;
    }
}

