/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.gui;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.data.StackWrapper;
import mrriegel.storagenetwork.gui.ContainerNetworkBase;
import mrriegel.storagenetwork.gui.GuiContainerBase;
import mrriegel.storagenetwork.helper.UtilTileEntity;
import mrriegel.storagenetwork.jei.JeiHooks;
import mrriegel.storagenetwork.jei.Settings;
import mrriegel.storagenetwork.network.ClearMessage;
import mrriegel.storagenetwork.network.InsertMessage;
import mrriegel.storagenetwork.network.RequestMessage;
import mrriegel.storagenetwork.network.SortMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.request.TileRequest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainerStorageInventory
extends GuiContainerBase {
    private static final int MOUSE_BTN_RIGHT = 1;
    private static final int MOUSE_BTN_LEFT = 0;
    public static final String NBT_SEARCH = "storagenetwork_search";
    protected ResourceLocation texture;
    protected int page = 1;
    protected int maxPage = 1;
    public List<StackWrapper> stacks;
    public List<StackWrapper> craftableStacks;
    protected ItemStack over = ItemStack.field_190927_a;
    protected GuiTextField searchBar;
    protected Button direction;
    protected Button sort;
    protected Button jei;
    protected List<GuiContainerBase.ItemSlot> slots;
    protected long lastClick;
    private Button clearTextBtn;
    private boolean forceFocus;

    public GuiContainerStorageInventory(ContainerNetworkBase inventorySlotsIn) {
        super(inventorySlotsIn);
        this.field_146999_f = 176;
        this.field_147000_g = 256;
        this.stacks = Lists.newArrayList();
        this.craftableStacks = Lists.newArrayList();
        PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage(0, ItemStack.field_190927_a, false, false));
        this.lastClick = System.currentTimeMillis();
    }

    protected boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchBar = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 81, this.field_147009_r + 96, 85, this.field_146289_q.field_78288_b);
        this.searchBar.func_146203_f(30);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146193_g(0xFFFFFF);
        this.searchBar.func_146195_b(true);
        this.direction = new Button(0, this.field_147003_i + 7, this.field_147009_r + 93, "");
        this.func_189646_b(this.direction);
        this.sort = new Button(1, this.field_147003_i + 21, this.field_147009_r + 93, "");
        this.func_189646_b(this.sort);
        this.jei = new Button(4, this.field_147003_i + 35, this.field_147009_r + 93, "");
        if (ConfigHandler.jeiLoaded) {
            this.func_189646_b(this.jei);
        }
        this.clearTextBtn = new Button(5, this.field_147003_i + 64, this.field_147009_r + 93, "X");
        this.func_189646_b(this.clearTextBtn);
    }

    public abstract int getLines();

    public abstract int getColumns();

    public abstract boolean getDownwards();

    public abstract void setDownwards(boolean var1);

    public abstract TileRequest.EnumSortType getSort();

    public abstract void setSort(TileRequest.EnumSortType var1);

    public abstract BlockPos getPos();

    protected abstract int getDim();

    protected abstract boolean inField(int var1, int var2);

    protected abstract boolean inSearchbar(int var1, int var2);

    protected abstract boolean inX(int var1, int var2);

    protected abstract boolean isScreenValid();

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        ArrayList tmp;
        if (!this.isScreenValid()) {
            return;
        }
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        String search = this.searchBar.func_146179_b();
        ArrayList arrayList = tmp = search.equals("") ? Lists.newArrayList(this.stacks) : Lists.newArrayList();
        if (!search.equals("")) {
            for (StackWrapper s : this.stacks) {
                if (search.startsWith("@")) {
                    String name = UtilTileEntity.getModNameForItem(s.getStack().func_77973_b());
                    if (!name.toLowerCase().contains(search.toLowerCase().substring(1))) continue;
                    tmp.add(s);
                    continue;
                }
                if (search.startsWith("#")) {
                    CreativeTabs[] tooltip = s.getStack().func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    String tooltipString = Joiner.on((char)' ').join((Iterable)tooltip).toLowerCase();
                    if (!(tooltipString = ChatFormatting.stripFormatting((String)tooltipString)).toLowerCase().contains(search.toLowerCase().substring(1))) continue;
                    tmp.add(s);
                    continue;
                }
                if (search.startsWith("$")) {
                    StringBuilder oreDictStringBuilder = new StringBuilder();
                    for (CreativeTabs oreId : (CreativeTabs[])OreDictionary.getOreIDs((ItemStack)s.getStack())) {
                        String oreName = OreDictionary.getOreName((int)oreId);
                        oreDictStringBuilder.append(oreName).append(' ');
                    }
                    if (!oreDictStringBuilder.toString().toLowerCase().contains(search.toLowerCase().substring(1))) continue;
                    tmp.add(s);
                    continue;
                }
                if (search.startsWith("%")) {
                    StringBuilder creativeTabStringBuilder = new StringBuilder();
                    for (CreativeTabs creativeTab : s.getStack().func_77973_b().getCreativeTabs()) {
                        if (creativeTab == null) continue;
                        String creativeTabName = creativeTab.func_78024_c();
                        creativeTabStringBuilder.append(creativeTabName).append(' ');
                    }
                    if (!creativeTabStringBuilder.toString().toLowerCase().contains(search.toLowerCase().substring(1))) continue;
                    tmp.add(s);
                    continue;
                }
                if (!s.getStack().func_82833_r().toLowerCase().contains(search.toLowerCase())) continue;
                tmp.add(s);
            }
        }
        Collections.sort(tmp, new Comparator<StackWrapper>(){
            int mul;
            {
                this.mul = GuiContainerStorageInventory.this.getDownwards() ? -1 : 1;
            }

            @Override
            public int compare(StackWrapper o2, StackWrapper o1) {
                switch (GuiContainerStorageInventory.this.getSort()) {
                    case AMOUNT: {
                        return Integer.compare(o1.getSize(), o2.getSize()) * this.mul;
                    }
                    case NAME: {
                        return o2.getStack().func_82833_r().compareToIgnoreCase(o1.getStack().func_82833_r()) * this.mul;
                    }
                    case MOD: {
                        return UtilTileEntity.getModNameForItem(o2.getStack().func_77973_b()).compareToIgnoreCase(UtilTileEntity.getModNameForItem(o1.getStack().func_77973_b())) * this.mul;
                    }
                }
                return 0;
            }
        });
        this.maxPage = tmp.size() / this.getColumns();
        if (tmp.size() % this.getColumns() != 0) {
            ++this.maxPage;
        }
        this.maxPage -= this.getLines() - 1;
        if (this.maxPage < 1) {
            this.maxPage = 1;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        this.searchBar.func_146194_f();
        this.slots = Lists.newArrayList();
        int index = (this.page - 1) * this.getColumns();
        for (int jj = 0; jj < this.getLines(); ++jj) {
            int in;
            for (int ii = 0; ii < this.getColumns() && (in = index++) < tmp.size(); ++ii) {
                this.slots.add(new GuiContainerBase.ItemSlot(((StackWrapper)tmp.get(in)).getStack(), this.field_147003_i + 8 + ii * 18, this.field_147009_r + 10 + jj * 18, ((StackWrapper)tmp.get(in)).getSize(), this.field_147003_i, this.field_147009_r, true, true, ConfigHandler.smallFont, true));
            }
        }
        for (GuiContainerBase.ItemSlot s : this.slots) {
            s.drawSlot(mouseX, mouseY);
        }
        for (GuiContainerBase.ItemSlot s : this.slots) {
            if (s.isMouseOverSlot(mouseX, mouseY)) {
                this.over = s.stack;
                break;
            }
            this.over = ItemStack.field_190927_a;
        }
        if (this.slots.isEmpty()) {
            this.over = ItemStack.field_190927_a;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        if (!this.isScreenValid()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.drawTooltips(mouseX, mouseY);
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (!this.isScreenValid()) {
            return;
        }
        if (this.searchBar.func_146206_l() && ConfigHandler.jeiLoaded && Settings.jeiSearch) {
            JeiHooks.setFilterText(this.searchBar.func_146179_b());
        }
        if (this.forceFocus) {
            this.searchBar.func_146195_b(true);
            if (this.searchBar.func_146206_l()) {
                this.forceFocus = false;
            }
        }
    }

    public void drawTooltips(int mouseX, int mouseY) {
        for (GuiContainerBase.ItemSlot s : this.slots) {
            if (!s.isMouseOverSlot(mouseX, mouseY)) continue;
            s.drawTooltip(mouseX, mouseY);
        }
        if (this.inSearchbar(mouseX, mouseY)) {
            ArrayList lis = Lists.newArrayList();
            if (!GuiContainerStorageInventory.func_146272_n()) {
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.shift", (Object[])new Object[0]));
            } else {
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_0", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_1", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_2", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_3", (Object[])new Object[0]));
            }
            this.func_146283_a(lis, mouseX, mouseY);
        }
        if (this.clearTextBtn.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.tooltip_clear", (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.sort.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)("gui.storagenetwork.req.tooltip_" + this.getSort().toString()), (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.direction.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.sort", (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.jei != null && this.jei.func_146115_a()) {
            String s = I18n.func_135052_a((String)(Settings.jeiSearch ? "gui.storagenetwork.fil.tooltip_jei_on" : "gui.storagenetwork.fil.tooltip_jei_off"), (Object[])new Object[0]);
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{s}), mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        boolean doSort = true;
        if (button.field_146127_k == 2 && this.page > 1) {
            --this.page;
        } else if (button.field_146127_k == 3 && this.page < this.maxPage) {
            ++this.page;
        } else if (button.field_146127_k == 0) {
            this.setDownwards(!this.getDownwards());
        } else if (button.field_146127_k == 1) {
            this.setSort(this.getSort().next());
        } else if (button.field_146127_k == 4) {
            doSort = false;
            Settings.jeiSearch = !Settings.jeiSearch;
        } else if (button.field_146127_k == this.clearTextBtn.field_146127_k) {
            doSort = false;
            this.searchBar.func_146180_a("");
            this.forceFocus = true;
        }
        if (doSort) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new SortMessage(this.getPos(), this.getDownwards(), this.getSort()));
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBar.func_146195_b(false);
        if (this.inSearchbar(mouseX, mouseY)) {
            this.searchBar.func_146195_b(true);
            if (mouseButton == 1) {
                this.searchBar.func_146180_a("");
            }
        } else if (this.inX(mouseX, mouseY)) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new ClearMessage());
            PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage(0, ItemStack.field_190927_a, false, false));
        } else if (this.over != null && !this.over.func_190926_b() && (mouseButton == 0 || mouseButton == 1) && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.canClick()) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage(mouseButton, this.over, GuiContainerStorageInventory.func_146272_n(), GuiContainerStorageInventory.func_146271_m()));
            this.lastClick = System.currentTimeMillis();
        } else if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() != null && !this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.inField(mouseX, mouseY) && this.canClick()) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new InsertMessage(this.getDim(), mouseButton, this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()));
            this.lastClick = System.currentTimeMillis();
        }
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            Keyboard.enableRepeatEvents((boolean)true);
            if (this.searchBar.func_146201_a(typedChar, keyCode)) {
                PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage(0, ItemStack.field_190927_a, false, false));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.searchBar != null) {
            this.searchBar.func_146178_a();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.inField(i, j)) {
            int mouse = Mouse.getEventDWheel();
            if (mouse == 0) {
                return;
            }
            if (mouse > 0 && this.page > 1) {
                --this.page;
            }
            if (mouse < 0 && this.page < this.maxPage) {
                ++this.page;
            }
        }
    }

    public class Button
    extends GuiButton {
        public Button(int id, int x, int y, String str) {
            super(id, x, y, 14, 14, str);
        }

        public Button(int id, int x, int y, int width, String str) {
            super(id, x, y, width, 14, str);
        }

        public void func_191745_a(Minecraft mc, int x, int y, float pticks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(GuiContainerStorageInventory.this.texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 162 + 14 * k, 0, this.field_146120_f, this.field_146121_g);
                if (this.field_146127_k == 0) {
                    this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 3, 176 + (GuiContainerStorageInventory.this.getDownwards() ? 6 : 0), 14, 6, 8);
                }
                if (this.field_146127_k == 1) {
                    this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 3, 188 + (GuiContainerStorageInventory.this.getSort() == TileRequest.EnumSortType.AMOUNT ? 6 : (GuiContainerStorageInventory.this.getSort() == TileRequest.EnumSortType.MOD ? 12 : 0)), 14, 6, 8);
                }
                if (this.field_146127_k == 4) {
                    this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 3, 176 + (Settings.jeiSearch ? 0 : 6), 22, 6, 8);
                }
                this.func_146119_b(mc, x, y);
                int l = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    l = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }
}

