/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import shetiphian.core.client.Localization;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBaseDirectional;

public class TileEntityVaultTank
extends TileEntityVaultBaseDirectional {
    public final FluidTank tank = new FluidTank(16000);
    private String displayData = "";

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        NBTTagCompound nbtCompound = new NBTTagCompound();
        this.tank.writeToNBT(nbtCompound);
        nbtTag.func_74782_a("Tank", (NBTBase)nbtCompound);
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        NBTTagCompound nbtCompound = nbtTag.func_74775_l("Tank");
        this.tank.readFromNBT(nbtCompound);
    }

    public void buildNBT_SyncOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SyncOnly(nbtTag);
        if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0) {
            nbtTag.func_74778_a("displayData", this.tank.getFluid().amount + "mB - ^%" + this.tank.getFluid().getUnlocalizedName() + "%");
        }
    }

    public void processNBT_SyncOnly(NBTTagCompound nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        if (nbtTag.func_74764_b("displayData")) {
            String[] parts = nbtTag.func_74779_i("displayData").split("\\^");
            if (parts.length == 2 && parts[1].length() > 2 && parts[1].startsWith("%") & parts[1].endsWith("%")) {
                parts[1] = Localization.get((String)parts[1].substring(1, parts[1].length() - 1));
                this.displayData = parts[0] + parts[1];
            }
        } else {
            this.displayData = null;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            TileEntity oTile;
            if (facing != null && (oTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()))) != null && oTile.hasCapability(capability, facing)) {
                return (T)oTile.getCapability(capability, facing);
            }
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected boolean isEmpty() {
        return this.tank.getFluidAmount() < 1;
    }

    @Override
    protected void tryTransfer(TileEntity tile) {
        IFluidHandler handler;
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing.func_176734_d()) && (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing.func_176734_d())) != null) {
            this.tank.drain(handler.fill(this.tank.getFluid(), true), true);
        }
    }

    @Override
    public List<String> getExtraHudInfo(List<String> info, boolean isWaila) {
        if (isWaila) {
            info.add(Localization.get((String)"hud.msg.stored") + " " + Localization.get((String)"hud.msg.fluid"));
            if (Strings.isNullOrEmpty((String)this.displayData)) {
                info.add(Localization.get((String)"hud.msg.empty"));
            } else {
                info.add(this.displayData);
            }
        }
        return info;
    }
}

