/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.item;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.multistorage.Configuration;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.block.VaultHelper;
import shetiphian.multistorage.common.misc.FluidConcrete;
import shetiphian.multistorage.common.tileentity.IVaultWall;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBase;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBroken;
import shetiphian.multistorage.common.tileentity.TileEntityVaultCorer;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;

public class ItemBlockVault
extends ItemBlockMulti
implements IColored {
    public ItemBlockVault(Block block) {
        super(block, "BlockVault", Values.nameMapper);
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        if (Configuration.SETTINGS.VAULT.permissionVault != 0) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 15));
            for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
                ItemStack stack;
                Fluid fluid = FluidRegistry.getFluid((String)("concrete_" + dyeColor.func_176610_l()));
                if (fluid == null || (stack = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000))).func_190926_b()) continue;
                list.add((Object)stack);
            }
            this.addColoured(list, new ItemStack((Item)this, 1, 1));
            for (int index = 2; index < 14; ++index) {
                BlockVault.EnumType type = BlockVault.EnumType.byValue(index);
                if (type == null || type.getValue() <= 1) continue;
                this.addColoured(list, new ItemStack((Item)this, 1, index));
            }
        }
    }

    private void addColoured(NonNullList<ItemStack> list, ItemStack stack) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ItemStack colored = stack.func_77946_l();
            colored.func_77983_a("color", (NBTBase)new NBTTagString(color.func_176610_l()));
            colored.func_77983_a("cvalue", (NBTBase)new NBTTagInt(color.field_193351_w));
            list.add((Object)colored);
        }
    }

    public int func_77647_b(int damage) {
        return damage > 20 ? 14 : damage;
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        TileEntity tile;
        if (stack.func_77952_i() == 15 && (!((tile = world.func_175625_s(pos)) instanceof IVaultWall) || tile instanceof TileEntityVaultDoor)) {
            return false;
        }
        return stack.func_77952_i() == 100 || super.func_179222_a(world, pos, side, player, stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() == 100) {
            if (FluidConcrete.pourWall(world, pos, player, EnumDyeColor.WHITE)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    Function.giveItem((EntityPlayer)player, (ItemStack)new ItemStack(Items.field_151133_ar), null);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        int blockMeta = stack.func_77952_i();
        if (blockMeta > 20) {
            blockMeta = 14;
        }
        if (player instanceof FakePlayer && (blockMeta == 0 || blockMeta == 15)) {
            return EnumActionResult.FAIL;
        }
        if (!(blockMeta != 0 || VaultHelper.canPlayerPlaceDoor(player) && VaultHelper.getDoorStart(world, pos.func_177972_a(facing), player) != null)) {
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        NBTTagCompound tag;
        if (stack.func_77952_i() == 100 || player instanceof FakePlayer && (stack.func_77952_i() == 0 || stack.func_77952_i() == 15)) {
            return false;
        }
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityVaultBroken) {
            ((TileEntityVaultBroken)tile).setTypeBase(BlockVault.EnumType.byValue(stack.func_77952_i() - 20));
        } else if (tile instanceof TileEntityVaultCorer) {
            ((TileEntityVaultCorer)tile).setFacing(side.func_176734_d());
        }
        if (tile instanceof TileEntityVaultBase && stack.func_77952_i() > 0 && stack.func_77952_i() < 14 && (tag = stack.func_77978_p()) != null && tag.func_74764_b("color")) {
            String color = tag.func_74779_i("color");
            for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
                if (!dyeColor.func_176610_l().equalsIgnoreCase(color)) continue;
                ((TileEntityVaultBase)tile).recolor(EnumFacing.UP, dyeColor);
            }
        }
        return placed;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77960_j() == 100;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.hasContainerItem(stack) ? new ItemStack(Items.field_151133_ar) : ItemStack.field_190927_a;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.func_190926_b()) {
            NBTTagCompound tag;
            int damage = data.stack.func_77952_i();
            if (index == 0 && damage > 0 && damage < 14 && (tag = data.stack.func_77978_p()) != null && tag.func_74764_b("cvalue")) {
                return tag.func_74762_e("cvalue");
            }
        }
        return 0xFFFFFF;
    }

    protected void addToNameMap() {
        this.add(0, "", "vault_door#item", "door");
        this.add(1, "vault/", "wall_basic", "wall");
        this.add(2, "vault/", "wall_item", "item");
        this.add(3, "vault/", "wall_redstone", "redstone");
        this.add(4, "vault/", "wall_liquid", "liquid");
        this.add(5, "vault/", "wall_power_eu", "power.eu");
        this.add(6, "vault/", "wall_power_rf", "power.rf");
        this.add(7, "vault/", "wall_power_caps", "power.caps");
        this.add(13, "vault/", "wall_window", "window");
        this.add(15, "", "vault_corer#item", "corer");
        this.add(21, "vault/", "wall_basic_broken", "wall.broken");
        this.add(22, "vault/", "wall_item_broken", "item.broken");
        this.add(23, "vault/", "wall_redstone_broken", "redstone.broken");
        this.add(24, "vault/", "wall_liquid_broken", "liquid.broken");
        this.add(25, "vault/", "wall_power_eu_broken", "power.eu.broken");
        this.add(26, "vault/", "wall_power_rf_broken", "power.rf.broken");
        this.add(27, "vault/", "wall_power_caps_broken", "power.caps.broken");
        this.add(33, "vault/", "wall_window_broken", "window.broken");
        this.nameMapper.add(this.nameId, 100, "forge", "", "dynbucket", "bucket");
    }
}

