/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.block.IStorageType;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChest;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChestDense;
import shetiphian.multistorage.common.tileentity.TileEntityStorageBase;

class TypeStacking
implements IStorageType {
    private static final AxisAlignedBB AABB_DOUBLE_TOP = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_DOUBLE_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    private static final AxisAlignedBB AABB_TRIPLE_TOP = new AxisAlignedBB(0.0, -2.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_TRIPLE_MIDDLE = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 2.0, 1.0);
    private static final AxisAlignedBB AABB_TRIPLE_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 3.0, 1.0);

    TypeStacking() {
    }

    private boolean isSingle(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStorageType) {
            BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
            return type == BlockStorageType.EnumType.STACKABLE_SINGLE || type == BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE;
        }
        return false;
    }

    private boolean isTop(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStorageType) {
            BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
            return type == BlockStorageType.EnumType.STACKABLE_TOP || type == BlockStorageType.EnumType.DENSE_STACKABLE_TOP;
        }
        return false;
    }

    private boolean isMiddle(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStorageType) {
            BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
            return type == BlockStorageType.EnumType.STACKABLE_MIDDLE || type == BlockStorageType.EnumType.DENSE_STACKABLE_MIDDLE;
        }
        return false;
    }

    private boolean isBottom(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStorageType) {
            BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
            return type == BlockStorageType.EnumType.STACKABLE_BOTTOM || type == BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM;
        }
        return false;
    }

    private boolean isDense(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStorageType) {
            BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
            return type.isDense();
        }
        return false;
    }

    @Override
    public TileEntity createTileEntity(boolean dense) {
        return dense ? new TileEntityStackingChestDense() : new TileEntityStackingChest();
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Override
    public AxisAlignedBB getBoxBounds(BlockStorageType block, IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.isTop(state)) {
            return this.isMiddle(world.func_180495_p(pos.func_177977_b())) ? AABB_TRIPLE_TOP : AABB_DOUBLE_TOP;
        }
        if (this.isMiddle(state)) {
            return AABB_TRIPLE_MIDDLE;
        }
        if (this.isBottom(state)) {
            return this.isMiddle(world.func_180495_p(pos.func_177984_a())) ? AABB_TRIPLE_BOTTOM : AABB_DOUBLE_BOTTOM;
        }
        return Block.field_185505_j;
    }

    @Override
    public boolean addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        return false;
    }

    private void setAndRotate(World world, BlockPos pos1, IBlockState state1, BlockPos pos2, IBlockState state2) {
        Function.setBlock((World)world, (BlockPos)pos1, (IBlockState)state1, (boolean)false);
        Function.setBlock((World)world, (BlockPos)pos2, (IBlockState)state2, (boolean)false);
        this.copyRotation(this.getTile((IBlockAccess)world, pos1), this.getTile((IBlockAccess)world, pos2));
        Function.sync((World)world, (BlockPos)pos1, (IBlockState)state1);
        Function.sync((World)world, (BlockPos)pos2, (IBlockState)state2);
    }

    @Override
    public float getBlockHardness(IBlockState state, World world, BlockPos pos, float original) {
        return original;
    }

    @Override
    public void onBlockPlaced(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityStackingChest tile;
        boolean placeDense;
        boolean bl = placeDense = stack.func_77952_i() == 2;
        if (side == EnumFacing.DOWN) {
            BlockPos upPos = pos.func_177984_a();
            IBlockState upState = world.func_180495_p(upPos);
            IBlockState state = upState;
            if (this.isSingle(state)) {
                upState = upState.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_TOP : BlockStorageType.EnumType.STACKABLE_TOP)));
                state = state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(placeDense ? BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM : BlockStorageType.EnumType.STACKABLE_BOTTOM)));
                this.setAndRotate(world, upPos, upState, pos, state);
                return;
            }
            if (this.isBottom(state) && this.isTop(world.func_180495_p(pos.func_177981_b(2)))) {
                upState = upState.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_MIDDLE : BlockStorageType.EnumType.STACKABLE_MIDDLE)));
                state = state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(placeDense ? BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM : BlockStorageType.EnumType.STACKABLE_BOTTOM)));
                this.setAndRotate(world, upPos, upState, pos, state);
                return;
            }
        } else if (side == EnumFacing.UP) {
            BlockPos downPos = pos.func_177977_b();
            IBlockState downState = world.func_180495_p(downPos);
            IBlockState state = downState;
            if (this.isSingle(state)) {
                downState = downState.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM : BlockStorageType.EnumType.STACKABLE_BOTTOM)));
                state = state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(placeDense ? BlockStorageType.EnumType.DENSE_STACKABLE_TOP : BlockStorageType.EnumType.STACKABLE_TOP)));
                this.setAndRotate(world, downPos, downState, pos, state);
                return;
            }
            if (this.isTop(state) && this.isBottom(world.func_180495_p(pos.func_177979_c(2)))) {
                downState = downState.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_MIDDLE : BlockStorageType.EnumType.STACKABLE_MIDDLE)));
                state = state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(placeDense ? BlockStorageType.EnumType.DENSE_STACKABLE_TOP : BlockStorageType.EnumType.STACKABLE_TOP)));
                this.setAndRotate(world, downPos, downState, pos, state);
                return;
            }
        }
        if ((tile = this.getTile((IBlockAccess)world, pos)) != null) {
            tile.setFacing(player.func_174811_aO());
        }
    }

    private void copyRotation(TileEntityStackingChest from, TileEntityStackingChest to) {
        if (from != null && to != null) {
            to.setFacing(from.getFacing());
            Function.syncTile((TileEntity)to);
        }
    }

    private TileEntityStackingChest getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityStackingChest ? (TileEntityStackingChest)tile : null;
    }

    @Override
    public void onBlockRemoved(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        if (this.isTop(state)) {
            state = world.func_180495_p(pos.func_177977_b());
            if (this.isMiddle(state)) {
                Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_TOP : BlockStorageType.EnumType.STACKABLE_TOP))), (boolean)false);
            } else if (this.isBottom(state)) {
                Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE : BlockStorageType.EnumType.STACKABLE_SINGLE))), (boolean)false);
            }
        } else if (this.isMiddle(state)) {
            state = world.func_180495_p(pos.func_177984_a());
            if (this.isTop(state)) {
                Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE : BlockStorageType.EnumType.STACKABLE_SINGLE))), (boolean)false);
            }
            if (this.isBottom(state = world.func_180495_p(pos.func_177977_b()))) {
                Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE : BlockStorageType.EnumType.STACKABLE_SINGLE))), (boolean)false);
            }
        } else if (this.isBottom(state)) {
            state = world.func_180495_p(pos.func_177984_a());
            if (this.isMiddle(state)) {
                Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM : BlockStorageType.EnumType.STACKABLE_BOTTOM))), (boolean)false);
            } else if (this.isTop(state)) {
                Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE : BlockStorageType.EnumType.STACKABLE_SINGLE))), (boolean)false);
            }
        }
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, Block block, BlockStorageType.EnumType type) {
        drops.add((Object)new ItemStack(block, 1, 1 + (type.isDense() ? 1 : 0)));
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return !(tile instanceof TileEntityStorageBase) || ((TileEntityStorageBase)tile).getFacing() != side;
    }

    private BlockPos[] getChests(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (this.isSingle(state)) {
            return new BlockPos[]{null, pos, null};
        }
        if (this.isTop(state)) {
            if (this.isBottom(world.func_180495_p(pos.func_177977_b()))) {
                return new BlockPos[]{null, pos, pos.func_177977_b()};
            }
            if (this.isMiddle(world.func_180495_p(pos.func_177977_b()))) {
                if (this.isBottom(world.func_180495_p(pos.func_177979_c(2)))) {
                    return new BlockPos[]{pos, pos.func_177977_b(), pos.func_177979_c(2)};
                }
                Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM : BlockStorageType.EnumType.STACKABLE_BOTTOM))), (boolean)false);
                return new BlockPos[]{null, pos, pos.func_177977_b()};
            }
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE : BlockStorageType.EnumType.STACKABLE_SINGLE))), (boolean)false);
            return new BlockPos[]{null, pos, null};
        }
        if (this.isMiddle(state)) {
            boolean hasTop = this.isTop(world.func_180495_p(pos.func_177984_a()));
            boolean hasBottom = this.isBottom(world.func_180495_p(pos.func_177977_b()));
            if (hasTop && hasBottom) {
                return new BlockPos[]{pos.func_177984_a(), pos, pos.func_177977_b()};
            }
            if (!hasTop && !hasBottom) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE : BlockStorageType.EnumType.STACKABLE_SINGLE))), (boolean)false);
                return new BlockPos[]{null, pos, null};
            }
            if (hasTop) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM : BlockStorageType.EnumType.STACKABLE_BOTTOM))), (boolean)false);
                return new BlockPos[]{pos.func_177984_a(), pos, null};
            }
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_TOP : BlockStorageType.EnumType.STACKABLE_TOP))), (boolean)false);
            return new BlockPos[]{null, pos, pos.func_177977_b()};
        }
        if (this.isBottom(state)) {
            if (this.isTop(world.func_180495_p(pos.func_177984_a()))) {
                return new BlockPos[]{null, pos.func_177984_a(), pos};
            }
            if (this.isMiddle(world.func_180495_p(pos.func_177984_a()))) {
                if (this.isTop(world.func_180495_p(pos.func_177981_b(2)))) {
                    return new BlockPos[]{pos.func_177981_b(2), pos.func_177984_a(), pos};
                }
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_TOP : BlockStorageType.EnumType.STACKABLE_TOP))), (boolean)false);
                return new BlockPos[]{pos.func_177984_a(), pos, null};
            }
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)(this.isDense(state) ? BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE : BlockStorageType.EnumType.STACKABLE_SINGLE))), (boolean)false);
            return new BlockPos[]{null, pos, null};
        }
        return null;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityStackingChest tile = this.getTile((IBlockAccess)world, pos);
        if (tile == null || tile.getFacing() != facing.func_176734_d()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        BlockPos[] chests = this.getChests(world, pos);
        if (chests != null && chests[1] != null) {
            if (chests[0] != null && chests[2] != null) {
                return this.checkAndOpen(state, world, chests[1], player, facing, 4);
            }
            if (chests[2] != null) {
                return this.checkAndOpen(state, world, chests[1], player, facing, 3);
            }
            if (chests[0] != null) {
                return this.checkAndOpen(state, world, chests[1], player, facing, 2);
            }
            return this.checkAndOpen(state, world, chests[1], player, facing, 1);
        }
        return false;
    }

    private boolean checkAndOpen(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumFacing side, int index) {
        if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c().func_149688_o(state).func_76220_a()) {
            return false;
        }
        if ((index == 2 || index == 4) && world.func_180495_p(pos.func_177984_a().func_177972_a(side)).func_177230_c().func_149688_o(state).func_76220_a()) {
            return false;
        }
        if ((index == 3 || index == 4) && world.func_180495_p(pos.func_177977_b().func_177972_a(side)).func_177230_c().func_149688_o(state).func_76220_a()) {
            return false;
        }
        player.openGui((Object)MultiStorage.INSTANCE, index, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityStackingChest tile = this.getTile((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        EnumFacing facing = tile.getFacing().func_176746_e();
        BlockPos[] chests = this.getChests(world, pos);
        if (chests == null) {
            return false;
        }
        for (BlockPos cPos : chests) {
            if (cPos == null || (tile = this.getTile((IBlockAccess)world, cPos)) == null) continue;
            tile.setFacing(facing);
            Function.syncTile((TileEntity)tile);
        }
        return true;
    }

    @Override
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 0.0f;
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, BlockPos pos, int renderPass) {
        return 0xFFFFFF;
    }

    @Override
    public ItemStack getPickBlock(RayTraceResult target, World world, BlockPos pos, EntityPlayer player, Block block, BlockStorageType.EnumType type) {
        return new ItemStack(block, 1, 1 + (type.isDense() ? 1 : 0));
    }
}

