/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.worldgen;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import mcjty.deepresonance.worldgen.DeepWorldGenerator;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class WorldTickHandler {
    public static WorldTickHandler instance = new WorldTickHandler();
    public static TIntObjectHashMap<ArrayDeque<RetroChunkCoord>> chunksToGen = new TIntObjectHashMap();
    public static TIntObjectHashMap<ArrayDeque<Pair<Integer, Integer>>> chunksToPreGen = new TIntObjectHashMap();

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        World world = event.world;
        int dim = world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.END) {
            ArrayDeque chunks = (ArrayDeque)chunksToGen.get(dim);
            if (chunks != null && !chunks.isEmpty()) {
                RetroChunkCoord r = (RetroChunkCoord)chunks.pollFirst();
                Pair<Integer, Integer> c = r.coord;
                long worldSeed = world.func_72905_C();
                Random rand = new Random(worldSeed);
                long xSeed = rand.nextLong() >> 3;
                long zSeed = rand.nextLong() >> 3;
                rand.setSeed(xSeed * (long)((Integer)c.getLeft()).intValue() + zSeed * (long)((Integer)c.getRight()).intValue() ^ worldSeed);
                DeepWorldGenerator.instance.generateWorld(rand, (Integer)r.coord.getLeft(), (Integer)r.coord.getRight(), world, false);
                chunksToGen.put(dim, (Object)chunks);
            } else if (chunks != null) {
                chunksToGen.remove(dim);
            }
        } else {
            Deque chunks = (Deque)chunksToPreGen.get(dim);
            if (chunks != null && !chunks.isEmpty()) {
                Pair c = (Pair)chunks.pollFirst();
                world.func_72964_e(((Integer)c.getLeft()).intValue(), ((Integer)c.getRight()).intValue());
            } else if (chunks != null) {
                chunksToPreGen.remove(dim);
            }
        }
    }

    public static class RetroChunkCoord {
        private static final THashSet<String> emptySet = new THashSet(0);
        public final Pair<Integer, Integer> coord;
        public final THashSet<String> generatedFeatures;

        public RetroChunkCoord(Pair<Integer, Integer> pos, NBTTagList features) {
            this.coord = pos;
            if (features == null) {
                this.generatedFeatures = emptySet;
            } else {
                int e = features.func_74745_c();
                this.generatedFeatures = new THashSet(e);
                for (int i = 0; i < e; ++i) {
                    this.generatedFeatures.add((Object)features.func_150307_f(i));
                }
            }
        }
    }
}

