/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystals;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.SuperGenerationConfiguration;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SoundTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ResonatingCrystalTileEntity
extends GenericTileEntity
implements ITickable {
    private float strength = 1.0f;
    private float power = 1.0f;
    private float efficiency = 1.0f;
    private float purity = 1.0f;
    private int cooldown = 0;
    private int resistance = SuperGenerationConfiguration.maxResistance;
    private float instability = 0.0f;
    private int pulses = 0;
    private float powerPerTick = -1.0f;
    private int rfPerTick = -1;
    private boolean glowing = false;
    public static Set<ResonatingCrystalTileEntity> todoCrystals = new HashSet<ResonatingCrystalTileEntity>();

    public int getResistance() {
        return this.resistance;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public float getInstability() {
        return this.instability;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getPower() {
        return this.power;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public float getPurity() {
        return this.purity;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setStrength(float strength) {
        this.strength = strength;
        this.markDirtyClient();
    }

    public boolean isEmpty() {
        return this.power < 1.0E-5f;
    }

    public void setPower(float power) {
        boolean oldempty = this.isEmpty();
        this.power = power;
        this.func_70296_d();
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            if (newempty) {
                this.resistance = SuperGenerationConfiguration.maxResistance;
            }
            this.markDirtyClient();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            todoCrystals.add(this);
        }
    }

    public void realUpdate() {
        this.markDirtyQuick();
        int microTicksLeft = 1000;
        if (this.purity > 20.0f) {
            System.out.println("Cool=" + this.cooldown + ", Pulses=" + this.pulses + ", Resist=" + this.resistance);
        }
        while (this.pulses > 0) {
            --this.pulses;
            if (this.cooldown <= microTicksLeft) {
                microTicksLeft -= this.cooldown;
                this.cooldown = 0;
            } else {
                this.cooldown -= microTicksLeft;
                microTicksLeft = 0;
            }
            this.handleSinglePulse();
        }
        if (this.cooldown < microTicksLeft) {
            this.resistance += (microTicksLeft - this.cooldown) / 12;
            if (this.resistance > SuperGenerationConfiguration.maxResistance) {
                this.resistance = SuperGenerationConfiguration.maxResistance;
            }
            this.cooldown = 0;
        } else {
            this.cooldown -= microTicksLeft;
        }
        if (this.instability > 0.0f) {
            this.handleInstability();
        }
    }

    private void handleInstability() {
        if (this.field_145850_b.field_73012_v.nextFloat() < SuperGenerationConfiguration.instabilityHandlingChance) {
            float tohandle = this.field_145850_b.field_73012_v.nextFloat() * this.instability;
            this.instability -= tohandle;
            if (tohandle > SuperGenerationConfiguration.instabilityExplosionThresshold) {
                SoundTools.playSound((World)this.field_145850_b, (SoundEvent)SoundEvents.field_187539_bB, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)1.0, (double)1.0);
                this.setPower(0.0f);
            } else if (tohandle > SuperGenerationConfiguration.instabilityBigDamageThresshold) {
                this.setPower(Math.max(0.0f, this.power - 10.0f));
                this.setPurity(Math.max(1.0f, this.purity - 10.0f));
            } else if (tohandle > SuperGenerationConfiguration.instabilitySmallDamageThresshold) {
                this.setPower(Math.max(0.0f, this.power - 1.0f));
                this.setPurity(Math.max(1.0f, this.purity - 1.0f));
            }
        }
    }

    private void handleSinglePulse() {
        if (this.cooldown > 0) {
            float badness = (float)Math.min(this.cooldown, 10) / (float)this.resistance;
            this.instability += badness;
            this.resistance = (int)(((float)this.resistance - 1000.0f * (1.0f - badness)) / 10.0f);
            if (this.resistance < 1) {
                this.resistance = 1;
            }
        } else {
            this.resistance -= 120;
            if (this.resistance < 1) {
                this.resistance = 1;
            }
        }
        this.cooldown = this.resistance;
    }

    public void pulse() {
        if (this.glowing && this.power > 0.0f) {
            ++this.pulses;
            this.markDirtyQuick();
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldempty = this.isEmpty();
        super.onDataPacket(net, packet);
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void setEfficiency(float efficiency) {
        this.efficiency = efficiency;
        this.markDirtyClient();
    }

    public void setPurity(float purity) {
        this.purity = purity;
        this.markDirtyClient();
    }

    public void setGlowing(boolean glowing) {
        if (this.glowing == glowing) {
            return;
        }
        this.glowing = glowing;
        this.pulses = 0;
        if (this.func_145831_w() != null) {
            this.markDirtyClient();
        } else {
            this.func_70296_d();
        }
    }

    public boolean setOwner(EntityPlayer player) {
        return false;
    }

    public String getOwnerName() {
        return "";
    }

    public UUID getOwnerUUID() {
        return null;
    }

    public float getPowerPerTick() {
        if (this.powerPerTick < 0.0f) {
            float totalRF = ResonatingCrystalTileEntity.getTotalPower(this.strength, this.purity);
            float numticks = totalRF / (float)ResonatingCrystalTileEntity.getRfPerTick(this.efficiency, this.purity);
            this.powerPerTick = 100.0f / numticks;
        }
        return this.powerPerTick;
    }

    public static float getTotalPower(float strength, float purity) {
        return 1000.0f * (float)ConfigMachines.power.maximumKiloRF * strength / 100.0f * (purity + 30.0f) / 130.0f;
    }

    public int getRfPerTick() {
        if (this.rfPerTick == -1) {
            this.rfPerTick = ResonatingCrystalTileEntity.getRfPerTick(this.efficiency, this.purity);
        }
        if (this.resistance < SuperGenerationConfiguration.maxResistance) {
            float factor = (float)(SuperGenerationConfiguration.maxResistance - this.resistance) * 19.0f / (float)SuperGenerationConfiguration.maxResistance + 1.0f;
            System.out.println("rfPerTick = " + this.rfPerTick + ", factor = " + factor);
            return (int)((float)this.rfPerTick * factor);
        }
        return this.rfPerTick;
    }

    public static int getRfPerTick(float efficiency, float purity) {
        return (int)((float)ConfigMachines.power.maximumRFPerTick * efficiency / 100.1f * (purity + 2.0f) / 102.0f + 1.0f);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cooldown = tagCompound.func_74762_e("cool");
        if (tagCompound.func_74764_b("resist")) {
            this.resistance = tagCompound.func_74762_e("resist");
            if (this.resistance == 0) {
                this.resistance = SuperGenerationConfiguration.maxResistance;
            }
        } else {
            this.resistance = SuperGenerationConfiguration.maxResistance;
        }
        this.instability = tagCompound.func_74760_g("instability");
        this.pulses = tagCompound.func_74762_e("pulses");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.strength = tagCompound.func_74760_g("strength");
        this.power = tagCompound.func_74760_g("power");
        this.efficiency = tagCompound.func_74760_g("efficiency");
        this.purity = tagCompound.func_74760_g("purity");
        this.glowing = tagCompound.func_74767_n("glowing");
        byte version = tagCompound.func_74771_c("version");
        if (version < 2) {
            this.power *= 20.0f;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("cool", this.cooldown);
        tagCompound.func_74768_a("resist", this.resistance);
        tagCompound.func_74776_a("instability", this.instability);
        tagCompound.func_74768_a("pulses", this.pulses);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74776_a("strength", this.strength);
        tagCompound.func_74776_a("power", this.power);
        tagCompound.func_74776_a("efficiency", this.efficiency);
        tagCompound.func_74776_a("purity", this.purity);
        tagCompound.func_74757_a("glowing", this.glowing);
        tagCompound.func_74774_a("version", (byte)2);
    }

    public static void spawnCrystal(EntityPlayer player, World world, BlockPos pos, int purity, int strength, int efficiency, int power) {
        world.func_180501_a(pos, ModBlocks.resonatingCrystalBlock.func_176203_a(0), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            resonatingCrystalTileEntity.setPurity(purity);
            resonatingCrystalTileEntity.setStrength(strength);
            resonatingCrystalTileEntity.setEfficiency(efficiency);
            resonatingCrystalTileEntity.setPower(power);
            float radPurity = resonatingCrystalTileEntity.getPurity();
            float radRadius = DRRadiationManager.calculateRadiationRadius(resonatingCrystalTileEntity.getStrength(), resonatingCrystalTileEntity.getEfficiency(), radPurity);
            float radStrength = DRRadiationManager.calculateRadiationStrength(resonatingCrystalTileEntity.getStrength(), radPurity);
            Logging.message((EntityPlayer)player, (String)("Crystal would produce " + radStrength + " radiation with a radius of " + radRadius));
        }
    }

    public static void spawnRandomCrystal(World world, Random random, BlockPos pos, int special) {
        world.func_180501_a(pos, ModBlocks.resonatingCrystalBlock.func_176203_a(0), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            if (special >= 5) {
                resonatingCrystalTileEntity.setStrength(1.0f);
                resonatingCrystalTileEntity.setPower(0.05f);
                resonatingCrystalTileEntity.setEfficiency(1.0f);
                resonatingCrystalTileEntity.setPurity(100.0f);
            } else if (special >= 3) {
                resonatingCrystalTileEntity.setStrength(100.0f);
                resonatingCrystalTileEntity.setPower(100.0f);
                resonatingCrystalTileEntity.setEfficiency(100.0f);
                resonatingCrystalTileEntity.setPurity(special == 4 ? 1.0f : 100.0f);
            } else {
                resonatingCrystalTileEntity.setStrength(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.01f);
                resonatingCrystalTileEntity.setPower(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 60.0f + 0.2f);
                resonatingCrystalTileEntity.setEfficiency(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.1f);
                resonatingCrystalTileEntity.setPurity(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 10.0f + 5.0f);
            }
        }
    }

    public static void spawnRandomCrystal(World world, Random random, BlockPos pos, float str, float pow, float eff, float pur) {
        world.func_180501_a(pos, ModBlocks.resonatingCrystalBlock.func_176203_a(0), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            resonatingCrystalTileEntity.setStrength(Math.min(100.0f, random.nextFloat() * str * 3.0f + 0.01f));
            resonatingCrystalTileEntity.setPower(Math.min(100.0f, random.nextFloat() * pow * 60.0f + 0.2f));
            resonatingCrystalTileEntity.setEfficiency(Math.min(100.0f, random.nextFloat() * eff * 3.0f + 0.1f));
            resonatingCrystalTileEntity.setPurity(Math.min(100.0f, random.nextFloat() * pur * 10.0f + 5.0f));
        }
    }

    private static float getRandomSpecial(Random random, int special) {
        return special == 0 ? random.nextFloat() : (special == 1 ? 0.5f : 1.0f);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

