/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystalizer;

import elec332.core.world.WorldHelper;
import javax.annotation.Nonnull;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.crystalizer.CrystalizerContainer;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CrystalizerTileEntity
extends GenericEnergyReceiverTileEntity
implements ITankHook,
DefaultSidedInventory,
ITickable {
    public static final String CMD_GETPROGRESS = "getProgress";
    public static final Key<Integer> PARAM_PROGRESS = new Key("progress", Type.INTEGER);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CrystalizerContainer.factory, 1);
    private TileTank rclTank;
    private static int totalProgress = 0;
    private int progress = 0;
    private LiquidCrystalFluidTagData mergedData = null;
    private static int clientProgress = 0;

    public CrystalizerTileEntity() {
        super((long)ConfigMachines.crystalizer.rfMaximum, (long)ConfigMachines.crystalizer.rfPerTick);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public static int getTotalProgress() {
        if (totalProgress == 0) {
            totalProgress = ConfigMachines.crystalizer.rclPerCrystal / ConfigMachines.crystalizer.rclPerTick;
        }
        return totalProgress;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.canCrystalize()) {
            return;
        }
        this.storage.extractEnergy((long)ConfigMachines.crystalizer.rfPerRcl, false);
        FluidStack fluidStack = this.rclTank.getTank().drain(ConfigMachines.crystalizer.rclPerTick, true);
        LiquidCrystalFluidTagData data = LiquidCrystalFluidTagData.fromStack(fluidStack);
        if (this.mergedData == null) {
            this.mergedData = data;
        } else if (data != null) {
            this.mergedData.merge(data);
        }
        this.handleProgress();
    }

    private void handleProgress() {
        ++this.progress;
        if (this.progress == 1) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
        if (this.progress >= CrystalizerTileEntity.getTotalProgress()) {
            this.progress = 0;
            this.makeCrystal();
            this.markDirtyClient();
        }
        this.func_70296_d();
    }

    public int getProgress() {
        return this.progress;
    }

    public static int getClientProgress() {
        return clientProgress;
    }

    private boolean canCrystalize() {
        if (this.rclTank == null || this.rclTank.getTank() == null) {
            return false;
        }
        if (this.storage.getEnergyStored() < (long)ConfigMachines.crystalizer.rfPerRcl) {
            return false;
        }
        if (this.hasCrystal()) {
            return false;
        }
        FluidStack fluidStack = this.rclTank.getTank().drain(ConfigMachines.crystalizer.rclPerTick, false);
        if (fluidStack == null || fluidStack.amount != ConfigMachines.crystalizer.rclPerTick) {
            return false;
        }
        LiquidCrystalFluidTagData data = LiquidCrystalFluidTagData.fromStack(fluidStack);
        return data != null;
    }

    public boolean hasCrystal() {
        ItemStack crystalStack = this.inventoryHelper.getStackInSlot(0);
        return !crystalStack.func_190926_b();
    }

    private void makeCrystal() {
        ItemStack stack = new ItemStack((Block)ModBlocks.resonatingCrystalBlock);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74776_a("power", 100.0f);
        compound.func_74776_a("strength", this.mergedData.getStrength() * 100.0f);
        compound.func_74776_a("efficiency", this.mergedData.getEfficiency() * 100.0f);
        compound.func_74776_a("purity", this.mergedData.getPurity() * 100.0f);
        compound.func_74774_a("version", (byte)2);
        stack.func_77982_d(compound);
        this.mergedData = null;
        this.inventoryHelper.setStackInSlot(0, stack);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("progress", this.progress);
        if (this.mergedData != null) {
            NBTTagCompound dataCompound = new NBTTagCompound();
            this.mergedData.writeDataToNBT(dataCompound);
            tagCompound.func_74782_a("data", (NBTBase)dataCompound);
            tagCompound.func_74768_a("amount", this.mergedData.getInternalTankAmount());
        }
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
        if (tagCompound.func_74764_b("data")) {
            NBTTagCompound dataCompound = (NBTTagCompound)tagCompound.func_74781_a("data");
            int amount = dataCompound.func_74762_e("amount");
            this.mergedData = LiquidCrystalFluidTagData.fromNBT(dataCompound, amount);
        } else {
            this.mergedData = null;
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    @Override
    public void hook(TileTank tank, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && this.rclTank == null && this.validRCLTank(tank)) {
            this.rclTank = tank;
        }
    }

    @Override
    public void unHook(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.rclTank, tank)) {
            this.rclTank = null;
            this.notifyAndMarkDirty();
        }
    }

    @Override
    public void onContentChanged(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.rclTank, tank) && !this.validRCLTank(tank)) {
            this.rclTank = null;
        }
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.func_174877_v().equals((Object)second.func_174877_v()) && first.func_145831_w().field_73011_w.getDimension() == second.func_145831_w().field_73011_w.getDimension();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public void requestProgressFromServer() {
        this.requestDataFromServer("deepresonance", CMD_GETPROGRESS, TypedMap.EMPTY);
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETPROGRESS.equals(command)) {
            return TypedMap.builder().put(PARAM_PROGRESS, (Object)this.calculateProgress()).build();
        }
        return null;
    }

    public int calculateProgress() {
        return this.progress * 100 / CrystalizerTileEntity.getTotalProgress();
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_GETPROGRESS.equals(command)) {
            clientProgress = (Integer)result.get(PARAM_PROGRESS);
            return true;
        }
        return false;
    }

    protected void notifyAndMarkDirty() {
        if (WorldHelper.chunkLoaded((World)this.func_145831_w(), (BlockPos)this.field_174879_c)) {
            this.func_70296_d();
            this.func_145831_w().func_175685_c(this.field_174879_c, this.field_145854_h, false);
        }
    }
}

