/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageGridProcessingTransfer
extends MessageHandlerPlayerToServer<MessageGridProcessingTransfer>
implements IMessage {
    private Collection<ItemStack> inputs;
    private Collection<ItemStack> outputs;

    public MessageGridProcessingTransfer() {
    }

    public MessageGridProcessingTransfer(Collection<ItemStack> inputs, Collection<ItemStack> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.inputs = new ArrayList<ItemStack>(size);
        for (i = 0; i < size; ++i) {
            this.inputs.add(StackUtils.readItemStack(buf));
        }
        size = buf.readInt();
        this.outputs = new ArrayList<ItemStack>(size);
        for (i = 0; i < size; ++i) {
            this.outputs.add(StackUtils.readItemStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.inputs.size());
        for (ItemStack stack : this.inputs) {
            StackUtils.writeItemStack(buf, stack);
        }
        buf.writeInt(this.outputs.size());
        for (ItemStack stack : this.outputs) {
            StackUtils.writeItemStack(buf, stack);
        }
    }

    @Override
    public void handle(MessageGridProcessingTransfer message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerGrid && (grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getType() == GridType.PATTERN) {
            ItemHandlerBase handler = ((NetworkNodeGrid)grid).getProcessingMatrix();
            this.clearInputsAndOutputs(handler);
            this.setInputs(handler, message.inputs);
            this.setOutputs(handler, message.outputs);
        }
    }

    private void clearInputsAndOutputs(ItemHandlerBase handler) {
        for (int i = 0; i < 18; ++i) {
            handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    private void setInputs(ItemHandlerBase handler, Collection<ItemStack> stacks) {
        this.setSlots(handler, stacks, 0, 9);
    }

    private void setOutputs(ItemHandlerBase handler, Collection<ItemStack> stacks) {
        this.setSlots(handler, stacks, 9, 18);
    }

    private void setSlots(ItemHandlerBase handler, Collection<ItemStack> stacks, int begin, int end) {
        for (ItemStack stack : stacks) {
            handler.setStackInSlot(begin, stack);
            if (++begin < end) continue;
            break;
        }
    }
}

