/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridFluidDelta
implements IMessage,
IMessageHandler<MessageGridFluidDelta, IMessage> {
    private INetwork network;
    private FluidStack stack;
    private int delta;
    private GridStackFluid clientStack;

    public MessageGridFluidDelta() {
    }

    public MessageGridFluidDelta(INetwork network, FluidStack stack, int delta) {
        this.network = network;
        this.stack = stack;
        this.delta = delta;
    }

    public void fromBytes(ByteBuf buf) {
        this.clientStack = new GridStackFluid(StackUtils.readFluidStack(buf), buf.readBoolean() ? new StorageTrackerEntry(buf) : null);
        this.delta = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        StackUtils.writeFluidStack(buf, this.stack);
        IStorageTracker.IStorageTrackerEntry entry = this.network.getFluidStorageTracker().get(this.stack);
        buf.writeBoolean(entry != null);
        if (entry != null) {
            buf.writeLong(entry.getTime());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
        }
        buf.writeInt(this.delta);
    }

    public IMessage onMessage(MessageGridFluidDelta message, MessageContext ctx) {
        GuiBase.executeLater(GuiGrid.class, grid -> {
            grid.getView().postChange(message.clientStack, message.delta);
            grid.getView().sort();
        });
        return null;
    }
}

