/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerProxy
implements IItemHandler {
    private IItemHandler insertHandler;
    private IItemHandler extractHandler;

    public ItemHandlerProxy(IItemHandler insertHandler, IItemHandler extractHandler) {
        this.insertHandler = insertHandler;
        this.extractHandler = extractHandler;
    }

    public int getSlots() {
        return this.insertHandler.getSlots() + this.extractHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot < this.insertHandler.getSlots() ? this.insertHandler.getStackInSlot(slot) : this.extractHandler.getStackInSlot(slot - this.insertHandler.getSlots());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return slot < this.insertHandler.getSlots() ? this.insertHandler.insertItem(slot, stack, simulate) : stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return slot >= this.insertHandler.getSlots() ? this.extractHandler.extractItem(slot - this.insertHandler.getSlots(), amount, simulate) : ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return slot < this.insertHandler.getSlots() ? this.insertHandler.getSlotLimit(slot) : this.extractHandler.getSlotLimit(slot - this.insertHandler.getSlots());
    }
}

