/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.solderer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRecipe;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;

public class SoldererRecipeFactory {
    private final ResourceLocation name;
    private JsonObject json;

    public SoldererRecipeFactory(ResourceLocation name, JsonObject json) {
        this.name = name;
        this.json = json;
    }

    public ISoldererRecipe create(JsonContext context) {
        JsonArray rowsArray = JsonUtils.func_151214_t((JsonObject)this.json, (String)"rows");
        if (rowsArray.size() != 3) {
            throw new JsonSyntaxException("Expected 3 rows, got " + rowsArray.size() + " rows");
        }
        final ArrayList<Object> rows = new ArrayList<Object>(3);
        for (JsonElement element : rowsArray) {
            if (element.isJsonNull()) {
                rows.add(StackUtils.emptyNonNullList());
                continue;
            }
            rows.add(NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context).func_193365_a()));
        }
        final ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)this.json, (String)"result"), (JsonContext)context);
        final int duration = JsonUtils.func_151203_m((JsonObject)this.json, (String)"duration");
        final boolean projectERecipe = JsonUtils.func_151209_a((JsonObject)this.json, (String)"projecte", (boolean)true);
        return new ISoldererRecipe(){

            @Override
            public ResourceLocation getName() {
                return SoldererRecipeFactory.this.name;
            }

            @Override
            @Nonnull
            public NonNullList<ItemStack> getRow(int row) {
                return (NonNullList)rows.get(row);
            }

            @Override
            @Nonnull
            public ItemStack getResult() {
                return result;
            }

            @Override
            public int getDuration() {
                return duration;
            }

            @Override
            public boolean isProjectERecipe() {
                return projectERecipe;
            }
        };
    }
}

