/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.container.ContainerReaderWriter;
import com.raoulvdberge.refinedstorage.network.MessageReaderWriterUpdate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ReaderWriterManager
implements IReaderWriterManager {
    private static final String NBT_CHANNELS = "ReaderWriterChannels";
    private static final String NBT_NAME = "Name";
    private INetwork network;
    private Runnable listener;
    private Map<String, IReaderWriterChannel> channels = new HashMap<String, IReaderWriterChannel>();

    public ReaderWriterManager(INetwork network, Runnable listener) {
        this.network = network;
        this.listener = listener;
    }

    @Override
    public void update() {
        for (IReaderWriterChannel channel : this.channels.values()) {
            for (IReaderWriterHandler handler : channel.getHandlers()) {
                handler.update(channel);
            }
        }
    }

    @Override
    @Nullable
    public IReaderWriterChannel getChannel(String name) {
        return this.channels.get(name);
    }

    @Override
    public void addChannel(String name) {
        this.channels.put(name, API.instance().createReaderWriterChannel(name, this.network));
        this.listener.run();
        this.sendUpdate();
    }

    @Override
    public void removeChannel(String name) {
        IReaderWriterChannel channel = this.getChannel(name);
        if (channel != null) {
            channel.getReaders().forEach(reader -> reader.setChannel(""));
            channel.getWriters().forEach(writer -> writer.setChannel(""));
            this.channels.remove(name);
            this.listener.run();
            this.sendUpdate();
        }
    }

    @Override
    public void sendUpdate() {
        this.network.world().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> player.field_71070_bA instanceof ContainerReaderWriter && ((ContainerReaderWriter)player.field_71070_bA).getReaderWriter().getNetwork() != null && this.network.getPosition().equals((Object)((ContainerReaderWriter)player.field_71070_bA).getReaderWriter().getNetwork().getPosition())).forEach(this::sendUpdateTo);
    }

    @Override
    public void sendUpdateTo(EntityPlayerMP player) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageReaderWriterUpdate(new ArrayList<String>(this.channels.keySet())), player);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList readerWriterChannelsList = new NBTTagList();
        for (Map.Entry<String, IReaderWriterChannel> entry : this.channels.entrySet()) {
            NBTTagCompound channelTag = entry.getValue().writeToNBT(new NBTTagCompound());
            channelTag.func_74778_a(NBT_NAME, entry.getKey());
            readerWriterChannelsList.func_74742_a((NBTBase)channelTag);
        }
        tag.func_74782_a(NBT_CHANNELS, (NBTBase)readerWriterChannelsList);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_CHANNELS)) {
            NBTTagList readerWriterChannelsList = tag.func_150295_c(NBT_CHANNELS, 10);
            for (int i = 0; i < readerWriterChannelsList.func_74745_c(); ++i) {
                NBTTagCompound channelTag = readerWriterChannelsList.func_150305_b(i);
                String name = channelTag.func_74779_i(NBT_NAME);
                IReaderWriterChannel channel = API.instance().createReaderWriterChannel(name, this.network);
                channel.readFromNBT(channelTag);
                this.channels.put(name, channel);
            }
        }
    }
}

