/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeInterface;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageItemExternal;
import com.raoulvdberge.refinedstorage.tile.TileInterface;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageItemItemHandler
extends StorageItemExternal {
    private NetworkNodeExternalStorage externalStorage;
    private Supplier<IItemHandler> handlerSupplier;
    private boolean connectedToInterface;

    public StorageItemItemHandler(NetworkNodeExternalStorage externalStorage, Supplier<IItemHandler> handlerSupplier) {
        this.externalStorage = externalStorage;
        this.handlerSupplier = handlerSupplier;
        TileEntity tile = externalStorage.getFacingTile();
        if (tile instanceof TileInterface) {
            this.handlerSupplier = ((NetworkNodeInterface)((TileInterface)tile).getNode())::getItems;
            this.connectedToInterface = true;
        }
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Override
    public int getCapacity() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0;
        }
        int capacity = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            capacity += Math.min(handler.getSlotLimit(i), handler.getStackInSlot(i).func_77976_d());
        }
        return capacity;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.add(handler.getStackInSlot(i).func_77946_l());
        }
        return stacks;
    }

    @Override
    public ItemStack insert(@Nonnull ItemStack stack, int size, boolean simulate) {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler != null && IFilterable.canTake((IItemHandler)this.externalStorage.getItemFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack)) {
            return StackUtils.emptyToNull(ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), (boolean)simulate));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        int remaining = size;
        ItemStack received = null;
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack got;
            ItemStack slot = handler.getStackInSlot(i);
            if (slot.func_190926_b() || !API.instance().getComparer().isEqual(slot, stack, flags) || (got = handler.extractItem(i, remaining, simulate)).func_190926_b()) continue;
            if (received == null) {
                received = got.func_77946_l();
            } else {
                received.func_190917_f(got.func_190916_E());
            }
            if ((remaining -= got.func_190916_E()) == 0) break;
        }
        return received;
    }

    @Override
    public int getStored() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            size += handler.getStackInSlot(i).func_190916_E();
        }
        return size;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.externalStorage.getAccessType();
    }
}

