/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageFluidExternal;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageItemExternal;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageItemItemHandler;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItem;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.integration.projecte.IntegrationProjectE;
import com.raoulvdberge.refinedstorage.integration.projecte.StorageItemTransmutationTable;
import com.raoulvdberge.refinedstorage.integration.storagedrawers.StorageItemItemRepository;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileExternalStorage;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeExternalStorage
extends NetworkNode
implements IStorageProvider,
IGuiStorage,
IComparable,
IFilterable,
IPrioritizable,
IType,
IAccessType {
    @CapabilityInject(value=IDrawerGroup.class)
    private static final Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = null;
    public static final String ID = "external_storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, new ItemHandlerListenerNetworkNode(this));
    private int priority = 0;
    private int compare = 3;
    private int mode = 0;
    private int type = 0;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int networkTicks;
    private List<StorageItemExternal> itemStorages = new CopyOnWriteArrayList<StorageItemExternal>();
    private List<StorageFluidExternal> fluidStorages = new CopyOnWriteArrayList<StorageFluidExternal>();

    public NetworkNodeExternalStorage(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.externalStorageUsage + (this.itemStorages.size() + this.fluidStorages.size()) * RS.INSTANCE.config.externalStoragePerStorageUsage;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        this.updateStorage(network);
    }

    @Override
    public void update() {
        super.update();
        if (this.network != null) {
            if (this.networkTicks++ == 0) {
                this.updateStorage(this.network);
                return;
            }
            for (StorageItemExternal storage : this.itemStorages) {
                storage.detectChanges(this.network);
            }
            boolean fluidChangeDetected = false;
            for (StorageFluidExternal storage : this.fluidStorages) {
                if (!storage.updateCache()) continue;
                fluidChangeDetected = true;
            }
            if (fluidChangeDetected) {
                this.network.getFluidStorageCache().invalidate();
            }
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        StackUtils.writeItems((IItemHandler)this.fluidFilters, 1, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 1, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
            this.network.getFluidStorageCache().sort();
        }
    }

    public void updateStorage(INetwork network) {
        IFluidHandler fluidHandler;
        this.itemStorages.clear();
        this.fluidStorages.clear();
        TileEntity facing = this.getFacingTile();
        if (this.type == 0) {
            if (facing != null) {
                IItemHandler itemHandler;
                if (DRAWER_GROUP_CAPABILITY != null && facing.hasCapability(DRAWER_GROUP_CAPABILITY, this.getDirection().func_176734_d())) {
                    this.itemStorages.add(new StorageItemItemRepository(this, () -> {
                        TileEntity f = this.getFacingTile();
                        return f != null && f.hasCapability(DRAWER_GROUP_CAPABILITY, this.getDirection().func_176734_d()) ? (IDrawerGroup)f.getCapability(DRAWER_GROUP_CAPABILITY, this.getDirection().func_176734_d()) : null;
                    }));
                } else if (!(facing.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, this.getDirection().func_176734_d()) && ((INetworkNodeProxy)facing.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, this.getDirection().func_176734_d())).getNode() instanceof IStorageProvider || (itemHandler = WorldUtils.getItemHandler(facing, this.getDirection().func_176734_d())) == null)) {
                    this.itemStorages.add(new StorageItemItemHandler(this, () -> WorldUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d())));
                }
            } else if (IntegrationProjectE.isLoaded() && this.world.func_180495_p(this.pos.func_177972_a(this.getDirection())).func_177230_c().func_149739_a().equals("tile.pe_transmutation_stone")) {
                this.itemStorages.add(new StorageItemTransmutationTable(this));
            }
        } else if (this.type == 1 && (fluidHandler = WorldUtils.getFluidHandler(facing, this.getDirection().func_176734_d())) != null) {
            this.fluidStorages.add(new StorageFluidExternal(this, () -> WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())));
        }
        network.getNodeGraph().addPostRebuildHandler(StorageCacheItem.INVALIDATE);
        network.getNodeGraph().addPostRebuildHandler(StorageCacheFluid.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        storages.addAll(this.itemStorages);
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        storages.addAll(this.fluidStorages);
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:external_storage";
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileExternalStorage.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileExternalStorage.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileExternalStorage.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileExternalStorage.PRIORITY;
    }

    @Override
    public TileDataParameter<Boolean, ?> getVoidExcessParameter() {
        return null;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileExternalStorage.ACCESS_TYPE;
    }

    @Override
    public String getVoidExcessType() {
        return null;
    }

    @Override
    public int getStored() {
        return TileExternalStorage.STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return TileExternalStorage.CAPACITY.getValue();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType type) {
        this.accessType = type;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
            this.network.getFluidStorageCache().invalidate();
        }
        this.markDirty();
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return TileExternalStorage.TYPE;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileExternalStorage.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
        if (this.network != null) {
            this.updateStorage(this.network);
        }
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    public ItemHandlerBase getItemFilters() {
        return this.itemFilters;
    }

    public ItemHandlerFluid getFluidFilters() {
        return this.fluidFilters;
    }

    public List<StorageItemExternal> getItemStorages() {
        return this.itemStorages;
    }

    public List<StorageFluidExternal> getFluidStorages() {
        return this.fluidStorages;
    }
}

