/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItem;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageDiskItem;
import com.raoulvdberge.refinedstorage.block.BlockStorage;
import com.raoulvdberge.refinedstorage.block.ItemStorageType;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileStorage;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IExcessVoidable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class NetworkNodeStorage
extends NetworkNode
implements IGuiStorage,
IStorageProvider,
IComparable,
IFilterable,
IPrioritizable,
IExcessVoidable,
IAccessType {
    public static final String ID = "storage";
    public static final String NBT_STORAGE = "Storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_VOID_EXCESS = "VoidExcess";
    private ItemHandlerBase filters = new ItemHandlerBase(9, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private StorageItem storage = new StorageItem(StorageDiskItem.getTag());
    private NBTTagCompound storageTagToRead = null;
    private ItemStorageType type;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 3;
    private int mode = 0;
    private boolean voidExcess = false;

    public NetworkNodeStorage(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public void update() {
        super.update();
        if (this.storageTagToRead != null) {
            this.storage = new StorageItem(this.storageTagToRead);
            this.storage.readFromNBT();
            if (this.network != null) {
                this.network.getItemStorageCache().invalidate();
            }
            this.storageTagToRead = null;
        }
    }

    public void onPlacedWithStorage(NBTTagCompound tag) {
        this.storageTagToRead = tag;
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.storageUsage;
    }

    public void onBreak() {
        this.storage.writeToNBT();
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getNodeGraph().addPostRebuildHandler(StorageCacheItem.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        storages.add(this.storage);
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_STORAGE)) {
            this.storageTagToRead = tag.func_74775_l(NBT_STORAGE);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        this.storage.writeToNBT();
        tag.func_74782_a(NBT_STORAGE, (NBTBase)this.storage.getStorageTag());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74757_a(NBT_VOID_EXCESS, this.voidExcess);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_VOID_EXCESS)) {
            this.voidExcess = tag.func_74767_n(NBT_VOID_EXCESS);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    public ItemStorageType getType() {
        if (this.type == null && this.world != null && this.world.func_180495_p(this.pos).func_177230_c() == RSBlocks.STORAGE) {
            this.type = (ItemStorageType)((Object)this.world.func_180495_p(this.pos).func_177229_b((IProperty)BlockStorage.TYPE));
        }
        return this.type == null ? ItemStorageType.TYPE_1K : this.type;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public boolean getVoidExcess() {
        return this.voidExcess;
    }

    @Override
    public void setVoidExcess(boolean voidExcess) {
        this.voidExcess = voidExcess;
        this.markDirty();
    }

    public StorageDiskItem getStorage() {
        return this.storage;
    }

    public ItemHandlerBase getFilters() {
        return this.filters;
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:storage." + this.getType().getId() + ".name";
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileStorage.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileStorage.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileStorage.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileStorage.PRIORITY;
    }

    @Override
    public TileDataParameter<Boolean, ?> getVoidExcessParameter() {
        return TileStorage.VOID_EXCESS;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileStorage.ACCESS_TYPE;
    }

    @Override
    public String getVoidExcessType() {
        return "items";
    }

    @Override
    public int getStored() {
        return TileStorage.STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return this.getType().getCapacity();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
        }
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
        }
    }

    class StorageItem
    extends StorageDiskItem {
        StorageItem(NBTTagCompound tag) {
            super(tag, NetworkNodeStorage.this.getCapacity());
            this.onPassContainerContext(NetworkNodeStorage.this::markDirty, NetworkNodeStorage.this::getVoidExcess, NetworkNodeStorage.this::getAccessType);
        }

        @Override
        public int getPriority() {
            return NetworkNodeStorage.this.priority;
        }

        @Override
        public ItemStack insert(@Nonnull ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)NetworkNodeStorage.this.filters, NetworkNodeStorage.this.mode, NetworkNodeStorage.this.compare, stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            return super.insert(stack, size, simulate);
        }
    }
}

