/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepCraft;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepProcess;
import com.raoulvdberge.refinedstorage.apiimpl.util.Comparer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class CraftingStep
implements ICraftingStep {
    public static final String NBT_CRAFTING_STEP_TYPE = "CraftingStepType";
    private static final String NBT_SATISFIED = "Satisfied_%d";
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_PATTERN_CONTAINER = "PatternContainer";
    private static final String NBT_STARTED_PROCESSING = "StartedProcessing";
    private static final String NBT_PRELIMINARY_STEPS = "PreliminarySteps";
    protected INetwork network;
    protected ICraftingPattern pattern;
    protected Map<Integer, Integer> satisfied;
    protected boolean startedProcessing;
    protected List<ICraftingStep> preliminarySteps;

    public CraftingStep(INetwork network, ICraftingPattern pattern, List<ICraftingStep> preliminarySteps) {
        this.network = network;
        this.pattern = pattern;
        this.satisfied = new HashMap<Integer, Integer>(this.getPattern().getOutputs().size());
        this.preliminarySteps = new ArrayList<ICraftingStep>(preliminarySteps);
    }

    public CraftingStep(INetwork network) {
        this.network = network;
    }

    public boolean readFromNBT(NBTTagCompound tag) {
        INetworkNodeProxy proxy;
        TileEntity container;
        ItemStack patternStack = new ItemStack(tag.func_74775_l(NBT_PATTERN));
        if (!patternStack.func_190926_b() && (container = this.network.world().func_175625_s(BlockPos.func_177969_a((long)tag.func_74763_f(NBT_PATTERN_CONTAINER)))) instanceof INetworkNodeProxy && (proxy = (INetworkNodeProxy)container).getNode() instanceof ICraftingPatternContainer) {
            this.pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.network.world(), patternStack, (ICraftingPatternContainer)proxy.getNode());
            this.satisfied = new HashMap<Integer, Integer>(this.pattern.getOutputs().size());
            for (ItemStack stack : this.pattern.getOutputs()) {
                int hashcode = API.instance().getItemStackHashCode(stack);
                String id = String.format(NBT_SATISFIED, hashcode);
                if (!tag.func_74764_b(id)) continue;
                this.satisfied.put(hashcode, tag.func_74762_e(id));
            }
            this.startedProcessing = tag.func_74767_n(NBT_STARTED_PROCESSING);
            NBTTagList preliminaryTagList = tag.func_150295_c(NBT_PRELIMINARY_STEPS, 10);
            this.preliminarySteps = new LinkedList<ICraftingStep>();
            for (int i = 0; i < preliminaryTagList.func_74745_c(); ++i) {
                NBTTagCompound stepTag = preliminaryTagList.func_150305_b(i);
                ICraftingStep step = CraftingStep.toCraftingStep(stepTag, this.network);
                if (step == null) continue;
                this.preliminarySteps.add(step);
            }
            return true;
        }
        return false;
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.pattern.getInputs().stream().filter(Objects::nonNull).filter(s -> !s.func_190926_b()).collect(Collectors.toList());
    }

    @Override
    public List<ICraftingStep> getPreliminarySteps() {
        return this.preliminarySteps != null ? this.preliminarySteps : Collections.emptyList();
    }

    @Override
    public boolean canStartProcessing() {
        return this.getPreliminarySteps().size() == 0;
    }

    @Override
    public void setStartedProcessing() {
        if (this.getPattern().isBlocking()) {
            this.network.getCraftingManager().setContainerBlocked(this.getPattern().getContainer(), true);
        }
        this.startedProcessing = true;
    }

    @Override
    public boolean hasStartedProcessing() {
        return this.startedProcessing;
    }

    @Override
    public boolean hasReceivedOutputs() {
        for (ItemStack stack : this.pattern.getOutputs()) {
            Integer received = this.satisfied.get(API.instance().getItemStackHashCode(stack));
            if (received != null && stack.func_190916_E() <= received) continue;
            return false;
        }
        if (this.getPattern().isBlocking()) {
            this.network.getCraftingManager().setContainerBlocked(this.getPattern().getContainer(), false);
        }
        return true;
    }

    @Override
    public boolean hasReceivedOutput(ItemStack stack) {
        return this.getReceivedOutput(stack) >= stack.func_190916_E();
    }

    @Override
    public int getReceivedOutput(ItemStack stack) {
        Integer received = this.satisfied.get(API.instance().getItemStackHashCode(stack));
        return received == null ? 0 : received;
    }

    @Override
    public boolean onReceiveOutput(ItemStack stack) {
        ItemStack compareStack = Comparer.stripTags(stack.func_77946_l());
        for (ItemStack output : this.pattern.getOutputs()) {
            int hash = API.instance().getItemStackHashCode(output);
            Integer received = this.satisfied.get(hash);
            if (received == null) {
                received = 0;
            }
            if (!API.instance().getComparer().isEqual(compareStack, output, 0x13 | (this.getPattern().isOredict() ? 8 : 0)) || received >= output.func_190916_E()) continue;
            int toReceive = Math.min(output.func_190916_E() - received, stack.func_190916_E());
            this.satisfied.put(hash, received + toReceive);
            stack.func_190918_g(toReceive);
            this.network.getCraftingManager().markCraftingMonitorForUpdate();
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        for (Map.Entry<Integer, Integer> entry : this.satisfied.entrySet()) {
            tag.func_74768_a(String.format(NBT_SATISFIED, entry.getKey()), entry.getValue().intValue());
        }
        tag.func_74782_a(NBT_PATTERN, (NBTBase)this.pattern.getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER, this.pattern.getContainer().getPosition().func_177986_g());
        tag.func_74757_a(NBT_STARTED_PROCESSING, this.startedProcessing);
        NBTTagList preliminaryTagList = new NBTTagList();
        for (ICraftingStep step : this.preliminarySteps) {
            preliminaryTagList.func_74742_a((NBTBase)step.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_PRELIMINARY_STEPS, (NBTBase)preliminaryTagList);
        return tag;
    }

    @Nullable
    protected AvailableType isItemAvailable(IStackList<ItemStack> items, IStackList<FluidStack> fluids, ItemStack stack, ItemStack actualStack, int compare) {
        if (actualStack == null || actualStack.func_190926_b() || !items.trackedRemove(actualStack, stack.func_190916_E())) {
            if (API.instance().getComparer().isEqual(stack, StackUtils.WATER_BOTTLE)) {
                FluidStack fluidStack = fluids.get(new FluidStack(FluidRegistry.WATER, 1000), compare);
                ItemStack emptyBottle = items.get(StackUtils.EMPTY_BOTTLE, compare);
                if (emptyBottle != null && fluidStack != null && !emptyBottle.func_190926_b() && items.trackedRemove(StackUtils.EMPTY_BOTTLE, 1)) {
                    return AvailableType.FLUID;
                }
            } else {
                FluidStack fluidInItem = (FluidStack)StackUtils.getFluid(stack, true).getValue();
                if (fluidInItem != null && StackUtils.hasFluidBucket(fluidInItem)) {
                    FluidStack fluidStack = fluids.get(fluidInItem, compare);
                    ItemStack bucket = items.get(StackUtils.EMPTY_BUCKET, compare);
                    if (bucket != null && fluidStack != null && !bucket.func_190926_b() && fluids.trackedRemove(fluidStack, fluidInItem.amount) && items.trackedRemove(bucket, 1)) {
                        return AvailableType.FLUID;
                    }
                }
            }
            return null;
        }
        return AvailableType.ITEM;
    }

    protected boolean extractItems(List<ItemStack> extractedItems, int compare, Deque<ItemStack> toInsertItems) {
        for (ItemStack input : this.getInputs()) {
            FluidStack fluidStack;
            compare = input.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
            ItemStack extracted = this.network.extractItem(input, input.func_190916_E(), compare, false);
            if (extracted != null) {
                extractedItems.add(extracted);
                continue;
            }
            boolean abort = true;
            if (API.instance().getComparer().isEqual(input, StackUtils.WATER_BOTTLE)) {
                fluidStack = this.network.extractFluid(new FluidStack(FluidRegistry.WATER, 1000), 1000, compare, true);
                ItemStack emptyBottleStack = this.network.extractItem(StackUtils.EMPTY_BOTTLE, 1, compare, false);
                if (fluidStack != null && fluidStack.amount == 1000 && emptyBottleStack != null) {
                    abort = false;
                    extractedItems.add(input.func_77946_l());
                }
            } else {
                FluidStack fluidInItem = (FluidStack)StackUtils.getFluid(input, true).getValue();
                if (fluidInItem != null) {
                    fluidStack = this.network.extractFluid(fluidInItem, fluidInItem.amount, compare, false);
                    ItemStack bucketStack = this.network.extractItem(StackUtils.EMPTY_BUCKET, 1, compare, false);
                    if (fluidStack != null && fluidStack.amount == fluidInItem.amount && bucketStack != null) {
                        abort = false;
                        extractedItems.add(input.func_77946_l());
                    }
                }
            }
            if (!abort) continue;
            toInsertItems.addAll(extractedItems);
            this.startedProcessing = false;
            return false;
        }
        return true;
    }

    @Nullable
    public static ICraftingStep toCraftingStep(NBTTagCompound tag, INetwork network) {
        CraftingStep step = null;
        switch (tag.func_74779_i(NBT_CRAFTING_STEP_TYPE)) {
            case "craft": {
                step = new CraftingStepCraft(network);
                break;
            }
            case "process": {
                step = new CraftingStepProcess(network);
            }
        }
        if (step != null && ((CraftingStep)step).readFromNBT(tag)) {
            return step;
        }
        return null;
    }

    static enum AvailableType {
        ITEM,
        FLUID;

    }
}

