/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public interface ICraftingTask {
    public static final String NBT_QUANTITY = "Quantity";
    public static final String NBT_PATTERN_ID = "PatternID";
    public static final String NBT_PATTERN_STACK = "PatternStack";
    public static final String NBT_PATTERN_CONTAINER = "PatternContainer";
    public static final String NBT_REQUESTED = "Requested";
    public static final String NBT_AUTOMATED = "Automated";

    public void calculate();

    public boolean update(Map<ICraftingPatternContainer, Integer> var1);

    public void onCancelled();

    public void reschedule();

    public int getQuantity();

    @Nullable
    public ItemStack getRequested();

    public NBTTagCompound writeToNBT(NBTTagCompound var1);

    default public NBTTagCompound writeDefaultsToNBT(NBTTagCompound tag) {
        tag.func_74768_a(NBT_QUANTITY, this.getQuantity());
        tag.func_74778_a(NBT_PATTERN_ID, this.getPattern().getId());
        tag.func_74782_a(NBT_PATTERN_STACK, (NBTBase)this.getPattern().getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER, this.getPattern().getContainer().getPosition().func_177986_g());
        tag.func_74757_a(NBT_AUTOMATED, this.isAutomated());
        if (this.getRequested() != null) {
            tag.func_74782_a(NBT_REQUESTED, (NBTBase)this.getRequested().serializeNBT());
        }
        return tag;
    }

    public List<ICraftingMonitorElement> getCraftingMonitorElements();

    public List<ICraftingPreviewElement> getPreviewStacks();

    public List<ICraftingStep> getSteps();

    public ICraftingPattern getPattern();

    public boolean isValid();

    public boolean isFinished();

    public IStackList<ItemStack> getMissing();

    public boolean isAutomated();
}

