/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.effects;

import com.google.common.collect.Lists;
import elec332.core.effects.AbilityHandler;
import elec332.core.effects.api.ability.Ability;
import elec332.core.effects.api.ability.WrappedAbility;
import elec332.core.effects.api.util.IAbilityPacket;
import elec332.core.effects.api.util.IEntityAbilityProperties;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public final class EntityAbilityProperties
implements IEntityAbilityProperties {
    private EntityLivingBase entity;
    private World world;
    protected List<WrappedAbility> activeEffects = Lists.newArrayList();
    private List<WrappedAbility> toRemove = Lists.newArrayList();

    @Override
    public void updateEffects() {
        for (WrappedAbility effect : this.activeEffects) {
            effect.onUpdate(this.entity);
        }
        this.checkRemove();
    }

    @Override
    public void addEffect(WrappedAbility effect) {
        this._addEffect(effect, true);
    }

    private void _addEffect(WrappedAbility ability, boolean add) {
        if (ability != null) {
            WrappedAbility q;
            if (!this.world.field_72995_K) {
                this.sendPacketAbility(ability, IAbilityPacket.PacketType.ADD);
            }
            if ((q = this.getEffect(ability.getAbility())) != null && q.getDuration() > 0) {
                q.mergeWith(ability);
                return;
            }
            this.activeEffects.add(ability);
            if (add) {
                ability.onActivated(this.entity);
            }
        }
    }

    @Override
    public void removeEffect(WrappedAbility ability) {
        this.removeEffect(ability.getAbility());
    }

    @Override
    public void removeEffect(Ability ability) {
        if (!this.world.field_72995_K) {
            this.sendPacketAbility(new WrappedAbility(ability, 0), IAbilityPacket.PacketType.REMOVE);
        }
        this._removeEffect(this.getEffect(ability));
    }

    private void _removeEffect(WrappedAbility effect) {
        if (effect != null) {
            this.toRemove.add(effect);
            effect.onRemoved(this.entity);
        }
    }

    @Override
    public WrappedAbility getEffect(Ability ability) {
        return this.getEffect(ability.getName());
    }

    @Override
    public WrappedAbility getEffect(String effect) {
        for (WrappedAbility wrappedAbility : this.activeEffects) {
            if (!wrappedAbility.getAbility().getName().equals(effect)) continue;
            return wrappedAbility;
        }
        return null;
    }

    @Override
    public void readFromPacket(IAbilityPacket packet) {
        switch (packet.getPacketType()) {
            case ADD: {
                this.addEffect(packet.getAbility());
                break;
            }
            case SYNC: {
                this._addEffect(packet.getAbility(), false);
                break;
            }
            case REMOVE: {
                this.removeEffect(packet.getAbility());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound compound) {
        this.checkRemove();
        NBTTagList list = new NBTTagList();
        for (WrappedAbility effect : this.activeEffects) {
            if (effect == null) continue;
            NBTTagCompound toSave = new NBTTagCompound();
            effect.writeToNBT(toSave);
            list.func_74742_a((NBTBase)toSave);
        }
        compound.func_74782_a("activeEffects", (NBTBase)list);
    }

    @Override
    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("activeEffects", 10);
        this.activeEffects.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.activeEffects.add(WrappedAbility.readEffectFromNBT(list.func_150305_b(i)));
        }
    }

    @Override
    public void init(Entity entity, World world) {
        this.entity = (EntityLivingBase)entity;
        this.world = world;
    }

    private void checkRemove() {
        if (!this.toRemove.isEmpty()) {
            for (WrappedAbility ability : this.toRemove) {
                this.activeEffects.remove(ability);
            }
            this.toRemove.clear();
        }
    }

    private void sendPacketAbility(WrappedAbility ability, IAbilityPacket.PacketType packetType) {
        AbilityHandler.instance.syncAbilityDataToClient(this.entity, ability, packetType);
    }
}

