/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.item.IItemSL;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;

public class ItemSL
extends Item
implements IRegistryObject,
IItemSL {
    protected int subItemCount;
    protected String itemName;
    protected String modId;

    public ItemSL(int subItemCount, String modId, String name) {
        this.subItemCount = subItemCount;
        this.modId = modId.toLowerCase(Locale.ROOT);
        this.func_77627_a(subItemCount > 1);
        this.func_77655_b(name);
    }

    @Override
    public void addRecipes(RecipeMaker recipes) {
    }

    @Override
    public void addOreDict() {
    }

    @Override
    public String getName() {
        return this.itemName;
    }

    @Override
    public String getFullName() {
        return this.modId + ":" + this.getName();
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public void getModels(Map<Integer, ModelResourceLocation> models) {
        if (this.field_77787_bX) {
            for (int i = 0; i < this.subItemCount; ++i) {
                models.put(i, new ModelResourceLocation(this.getFullName() + i, "inventory"));
            }
        } else {
            models.put(0, new ModelResourceLocation(this.getFullName(), "inventory"));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + this.modId + ":" + this.getNameForStack(stack);
    }

    public String getNameForStack(ItemStack stack) {
        return this.itemName + (this.field_77787_bX ? Integer.valueOf(stack.func_77952_i()) : "");
    }

    public Item func_77655_b(String name) {
        this.itemName = name;
        return super.func_77655_b(name);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return this.clOnItemRightClick(world, player, hand);
    }

    @Deprecated
    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.clOnItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Deprecated
    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.clOnItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Deprecated
    protected EnumActionResult clOnItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems(this, tab, (List<ItemStack>)list);
    }

    @Deprecated
    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab(item, tab)) {
            return;
        }
        if (this.field_77787_bX) {
            for (int i = 0; i < this.subItemCount; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        } else {
            list.add(new ItemStack((Item)this));
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        this.clAddInformation(stack, world, list, flag == ITooltipFlag.TooltipFlags.ADVANCED);
    }

    @Deprecated
    public void clAddInformation(ItemStack stack, World world, List<String> list, boolean advanced) {
        LocalizationHelper loc = SilentLib.instance.getLocalizationHelperForMod(this.modId);
        if (loc != null) {
            String name = this.getNameForStack(stack);
            list.addAll(loc.getItemDescriptionLines(name));
        }
    }
}

