/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.lib.item.ItemNamedSubtypes;
import net.silentchaos512.lib.util.ItemHelper;

public class ItemNamedSubtypesSorted
extends ItemNamedSubtypes {
    public final String[] sortedNames;

    public ItemNamedSubtypesSorted(String[] names, String[] sortedNames, String modId, String baseName) {
        super(names, modId, baseName);
        this.sortedNames = sortedNames;
        this.checkArrays();
    }

    protected void checkArrays() {
        if (this.names.length != this.sortedNames.length) {
            throw new IllegalArgumentException("names and sortedNames are different lengths!");
        }
        Object[] array1 = Arrays.copyOf(this.names, this.names.length);
        Object[] array2 = Arrays.copyOf(this.sortedNames, this.sortedNames.length);
        Arrays.sort(array1);
        Arrays.sort(array2);
        for (int i = 0; i < array1.length; ++i) {
            if (((String)array1[i]).equals(array2[i])) continue;
            throw new IllegalArgumentException("names and sortedNames don't contain the same elements!");
        }
    }

    @Override
    public void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab(item, tab)) {
            return;
        }
        for (String name : this.sortedNames) {
            list.add(this.getStack(name));
        }
    }
}

