/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.network.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.roots.particle.ParticleUtil;
import teamroots.roots.util.Misc;

public class MessageFairyTameFX
implements IMessage {
    public static Random random = new Random();
    static List<Float> reds = new ArrayList<Float>();
    static List<Float> greens = new ArrayList<Float>();
    static List<Float> blues = new ArrayList<Float>();
    double posX = 0.0;
    double posY = 0.0;
    double posZ = 0.0;

    public MessageFairyTameFX() {
    }

    public MessageFairyTameFX(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    static {
        reds.add(Float.valueOf(177.0f));
        reds.add(Float.valueOf(255.0f));
        reds.add(Float.valueOf(255.0f));
        reds.add(Float.valueOf(219.0f));
        reds.add(Float.valueOf(122.0f));
        greens.add(Float.valueOf(255.0f));
        greens.add(Float.valueOf(223.0f));
        greens.add(Float.valueOf(163.0f));
        greens.add(Float.valueOf(179.0f));
        greens.add(Float.valueOf(144.0f));
        blues.add(Float.valueOf(117.0f));
        blues.add(Float.valueOf(163.0f));
        blues.add(Float.valueOf(255.0f));
        blues.add(Float.valueOf(255.0f));
        blues.add(Float.valueOf(255.0f));
    }

    public static class MessageHolder
    implements IMessageHandler<MessageFairyTameFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageFairyTameFX message, MessageContext ctx) {
            float colorRand;
            float b;
            float g;
            float r;
            int ind;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            for (int k = 0; k < 40; ++k) {
                ind = Misc.random.nextInt(5);
                r = reds.get(ind).floatValue();
                g = greens.get(ind).floatValue();
                b = blues.get(ind).floatValue();
                colorRand = random.nextFloat();
                ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.0625f * (random.nextFloat() - 0.5f), 0.0625f * (random.nextFloat() - 0.5f), 0.0625f * (random.nextFloat() - 0.5f), r, g, b, 0.5f, 3.0f + Misc.random.nextFloat() * 3.0f, 30);
            }
            for (float k = 0.0f; k < 360.0f; k += Misc.random.nextFloat() * 24.0f) {
                ind = Misc.random.nextInt(5);
                r = reds.get(ind).floatValue();
                g = greens.get(ind).floatValue();
                b = blues.get(ind).floatValue();
                colorRand = random.nextFloat();
                double dx = Math.sin(Math.toRadians(k));
                double dz = Math.cos(Math.toRadians(k));
                ParticleUtil.spawnParticleStar((World)world, (float)(message.posX + dx), (float)message.posY, (float)(message.posZ + dz), 0.03125f * (random.nextFloat() - 0.5f), 0.0625f * random.nextFloat(), 0.03225f * (random.nextFloat() - 0.5f), r, g, b, 0.5f, 2.0f + Misc.random.nextFloat() * 2.0f, 80);
            }
            return null;
        }
    }
}

